/* $Id: GBWorkspace.hpp 39528 2017-10-05 15:27:37Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @GBWorkspace.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gui_project.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: GBWorkspace_.hpp


#ifndef GUI_CORE_GBWORKSPACE_HPP
#define GUI_CORE_GBWORKSPACE_HPP


// generated includes
#include <gui/objects/GBWorkspace_.hpp>
#include <gui/objects/GBProjectHandle.hpp>

// generated classes

BEGIN_NCBI_SCOPE

class CProjectService;

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CGBProjectHandle;
class CProjectItem;
class CScope;

///////////////////////////////////////////////////////////////////////////////
/// CGBWorkspace

class NCBI_GUIOBJECTS_EXPORT CGBWorkspace : public CGBWorkspace_Base
{
    typedef CGBWorkspace_Base Tparent;
    friend class ncbi::CProjectService;
public:
    typedef CAtomicCounter::TValue TId;
    typedef vector< CRef<CGBProjectHandle> >    TProjectVector;

public:
    CGBWorkspace(void);
    ~CGBWorkspace(void);

    TId GetId() { return m_Id; }

    CGBProjectHandle* GetProjectFromScope(const CScope& scope);
    CGBProjectHandle* GetProjectFromId(CGBProjectHandle::TId id);

    bool RemoveProject(CGBProjectHandle::TId id);


    /// Create a unique label for a project
    string  MakeUniqueProjectTitle(const string& label) const;

    vector<int> GetUnloadedProjects() const;
    vector<int> GetLoadedProjects() const;

    /// sets new filename for the Workspace
    /// updates path to projects so that they will be correct relative paths
    void   SetFilename(const string& filename) { m_Filename = filename; }
    string GetFilename() const { return m_Filename; }

private:
    // Prohibit copy constructor and assignment operator
    CGBWorkspace(const CGBWorkspace& value);
    CGBWorkspace& operator=(const CGBWorkspace& value);

protected:
    static CAtomicCounter   m_IdCounter;

    /// instance run-time Id, unique within an application session
    TId m_Id;

    /// filename assigned to the workspace
    string m_Filename;
};

/////////////////// CGBWorkspace inline methods
/////////////////// end of CGBWorkspace inline methods

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // GUI_CORE_GBWORKSPACE_HPP
/* Original file checksum: lines: 94, chars: 2592, CRC32: cab401f0 */
