/* $Id: GBProjectHandle.hpp 39250 2017-08-29 19:00:48Z katargir $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GBProjectHandle.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gui_project.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: GBProjectHandle_.hpp


#ifndef GUI_OBJECTS_GUI_PROJECT_GBPROJECTHANDLE_HPP
#define GUI_OBJECTS_GUI_PROJECT_GBPROJECTHANDLE_HPP


// generated includes
#include <gui/objects/GBProjectHandle_.hpp>
#include <objects/gbproj/igbproject.hpp>
#include <objects/gbproj/ProjectFolder.hpp>

#include <corelib/ncbistd.hpp>
#include <corelib/ncbimtx.hpp>

#include <set>


// generated classes

BEGIN_NCBI_SCOPE

class ICanceled;

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CGBProject;
class CGBProject_ver2;
class CWorkspaceFolder;
class CScope;

/////////////////////////////////////////////////////////////////////////////
class NCBI_GUIOBJECTS_EXPORT CGBProjectHandle : public CGBProjectHandle_Base
{
    typedef CGBProjectHandle_Base Tparent;
public:
    typedef CAtomicCounter::TValue  TId;
    typedef IGBProject::TAnnot      TAnnot;
    typedef IGBProject::TData       TData;
    typedef IGBProject::TDataLoaders       TDataLoaders;

public:
    static TId  sm_NullId;

    CGBProjectHandle(void);
    CGBProjectHandle(CGBProject_ver2& proj_impl);

    virtual ~CGBProjectHandle(void);

    /// @name Named serialization interface
    /// @{
    const IGBProject& GetProject() const;
    IGBProject&       SetProject();

    /// check to see if our project is loaded
    bool    IsLoaded() const;
    void    SetLoaded(bool loaded = true);

    bool    IsDirty() const;
    void    SetDirty(bool dirty = true);

    bool    GetDataModified() const;
    void    SetDataModified(bool modified = true);

    /// force a project to be loaded from an external stream
    bool    Load(CNcbiIstream& istr, ICanceled* canceledCallback);

    /// Serialize to a stream in a given format
    void    Save(CNcbiOstream& ostr, ESerialDataFormat fmt) const;

    /// establish a tie to the object manager via a scope
    virtual void    SetScope(CScope* scope);
    //virtual CScope* GetScope();
    virtual CScope* GetScope() const;
    /// @}

    /// @name State Management and Inspection
    /// @{
    /// ID already defined in projects
    TId  GetId() const; /// Retrieve the unique ID for our project

    static TId  GetNextId();

    /// retrieve our project's descriptor set
    const CProjectDescr& GetDescr() const;
    CProjectDescr&       SetDescr();

    /// Get a description of our contents.
    /// This is suitable for display in a GUI component such as a list view.
    const string& GetTitle(void) const;
    const string& GetShortTitle(void) const;

    /// Clear project
    virtual void Clear(void);

    bool    IsProjectItemLabelUnique(const string& label) const;

    /// Create a unique label for a project item
    string  MakeUniqueItemLabel(const string& label) const;

    /// Create a label for a folder that will be unique in the scope
    /// of the parent folder
    string  MakeUniqueFolderLabel(const string& label,
                                  objects::CProjectFolder& parent_folder)  const;

    /// Create a unique label for a data loader
    string  MakeUniqueDataLoaderLabel(const string& label) const;
    /// @}

    /// retrieve this project's version
    /// this is fixed per subclass
    IGBProject::EProjectVersion GetVersion() const;

    void AddDataLoader(CLoaderDescriptor& loader);
    const TDataLoaders& GetDataLoaders() const;
    TDataLoaders& GetDataLoaders();

    CRef<CLoaderDescriptor> FindDataLoaderByLabel(const string& label);

    CProjectFolder* FindProjectFolderById(CProjectFolder::TId id);
    CProjectItem*   FindProjectItemById(CProjectItem::TId id);

    string GetViewSettings(const string& view_type,
        const string& view_ins_id) const;

    void SaveViewSettings(const string& view_type,
        const string& view_ins_id, const string& settings);


    /// @name IGBProject forwarded interface
    /// @{
    void AddItem(CProjectItem& item, CProjectFolder& parent_folder);

    /// retrieve our project's data, in the form of a project folder
    /// this may be a contrived entity, and it is up to a project to determine
    /// what parts belong where
    const CProjectFolder& GetData() const;
    CProjectFolder&       SetData();

    /// retrieve a set of annotations for this project
    bool                      IsSetAnnot() const;
    const IGBProject::TAnnot& GetAnnot() const;
    IGBProject::TAnnot&       SetAnnot();

    /// SetCreateDate() will add a descriptor for creation date
    void SetCreateDate(const CDate& date);

    /// SetModifiedDate() will add a descriptor for the update date
    void SetModifiedDate(const CDate& date);
    /// @}

protected:
    void    x_LinkChildFolders(CProjectFolder& folder);
    void    x_FixIdGenerator(CGBProject_ver2& project);

private:
    // Prohibit copy constructor and assignment operator
    CGBProjectHandle(const CGBProjectHandle& value);
    CGBProjectHandle& operator=(const CGBProjectHandle& value);

protected:
    /// auto incremented ID counter
    static CAtomicCounter sm_Counter;

    /// the pointer to the actual project
    CIRef<IGBProject>   m_Project;

    /// unique runtime identifier for this project
    TId     m_Id;

    /// Dirty flag indicates whether the project has unsaved changes
    bool    m_Dirty;
    bool    m_DataModified = false;
    CAtomicCounter_WithAutoInit m_Loaded;

    CRef<CScope>    m_Scope; /// the Scope associated with the Project

    /// titles for this project, one brief the other longer
    mutable string m_Title;
    mutable string m_ShortTitle;
};

/////////////////// end of CGBProjectHandle inline methods

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // GUI_OBJECTS_GUI_PROJECT_GBPROJECTHANDLE_HPP
/* Original file checksum: lines: 86, chars: 2569, CRC32: ef33c3f2 */
