/* $Id: GBProject.hpp 28756 2013-08-23 17:44:43Z wuliangs $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @GBProject.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gui_project.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: GBProject_.hpp


#ifndef GUI_CORE_GBPROJECT_HPP
#define GUI_CORE_GBPROJECT_HPP


// generated includes
#include <corelib/ncbitime.hpp>
#include <corelib/ncbimtx.hpp>

#include <gui/objects/GBProject_.hpp>
#include <gui/objects/GBProjectHandle.hpp>
#include <objects/gbproj/igbproject.hpp>
#include <objects/gbproj/ProjectHistoryItem.hpp>
#include <objects/gbproj/ProjectAnnot.hpp>

#include <objmgr/scope.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class CDate;
class CProjectItem;

/////////////////////////////////////////////////////////////////////////////
class NCBI_GUIOBJECTS_EXPORT CGBProject :
    public CGBProject_Base,
    public IGBProject
{
    typedef CGBProject_Base Tparent;
public:
    /// our RAII-based locking primitive
    typedef CGuard<CGBProject> TGuard;

    CGBProject(void);
    ~CGBProject(void);

    /// @name Locking interface
    /// @{
    /// Synchronization Policy  this object may be accessed from multiple
    /// threads, so synchronization is required. Please use Lock() / Unlock()
    /// methods or CGuard class (preferred) to take ownership of the object.
    /// Methods of this class are NOT synchronized internally.
    /// When working with multiple objects lock the parent object first.
    virtual void Lock();
    virtual void Unlock();
    /// @}

    /// @name IGBProject Implementation
    /// @{
    EProjectVersion GetVersion() const;

    virtual void AddItem(CProjectItem& item, CProjectFolder& folder);

    const CProjectFolder& GetData() const;
    CProjectFolder&       SetData();

    bool                 IsSetDescr() const;
    const CProjectDescr& GetDescr() const;
    CProjectDescr&       SetDescr();

    /// retrieve the descriptor set for this project
    bool                      IsSetAnnot() const;
    const IGBProject::TAnnot& GetAnnot() const;
    IGBProject::TAnnot&       SetAnnot();

    /// retrieve the data loader descriptor set for this project
    virtual bool IsSetDataLoaders() const;
    virtual const TDataLoaders& GetDataLoaders() const;
    virtual TDataLoaders&       SetDataLoaders();

    /// retrieve the view descriptor set for this project
    bool                      IsSetViews() const;
    const IGBProject::TViews& GetViews() const;
    IGBProject::TViews&       SetViews();

    // protocol implementations (should be never called)
    virtual bool IsSetViewSettings() const {_ASSERT(false); return false; }
    virtual const TViewSettings& GetViewSettings() const { _ASSERT(false);return m_View_settings; }
    virtual TViewSettings&       SetViewSettings() { _ASSERT(false); return m_View_settings; }

    /// scope manipulators
    virtual void    SetScope(CScope* scope);
    virtual CScope* GetScope();

    /// SetCreateDate() will add a descriptor for creation date
    void SetCreateDate(const CDate& date);

    /// SetModifiedDate() will add a descriptor for the update date
    void SetModifiedDate(const CDate& date);
    /// @}

private:
    // Prohibit copy constructor and assignment operator
    CGBProject(const CGBProject& value);
    CGBProject& operator=(const CGBProject& value);

protected:
    CProjectFolder*  x_GetContainingFolder(CProjectFolder& root, CProjectItem& item);

private:
    /// mutex for controlling access to the current workspace
    CMutex m_Mutex;

    /// mutable project folder
    /// this is for compliance with the IGBProject interface
    mutable CRef<CProjectFolder> m_Folders;

    // the Scope associated with the Project
    CRef<CScope>    m_Scope;
    TViewSettings   m_View_settings; ///< fake var.should never be used
};

/////////////////// CGBProject inline methods


inline
IGBProject::EProjectVersion CGBProject::GetVersion() const
{
    return eVersion1;
}


/////////////////// end of CGBProject inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // GUI_CORE_GBPROJECT_HPP
/* Original file checksum: lines: 94, chars: 2554, CRC32: f8ccd1b9 */
