#ifndef GUI_CORE___VIEW_EXTENSIONS__HPP
#define GUI_CORE___VIEW_EXTENSIONS__HPP

/*  $Id: view_extensions.hpp 18488 2008-12-11 02:10:27Z voronov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software / database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software / database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Authors:  Andrey Yazhuk
 *
 * File Description:
 *
 */
#include <corelib/ncbistd.hpp>

#include <gui/widgets/data/object_contrib.hpp>


BEGIN_NCBI_SCOPE

class ISelectionClient;


///////////////////////////////////////////////////////////////////////////////
/// Helper function for adding commands provided by contributors to the menu.
void NCBI_GUICORE_EXPORT
    sAddScopedObjectCommands(wxMenu& menu,
                             vector<wxEvtHandler*>& handlers,
                             const string& ext_point_id,
                             TConstScopedObjects& objects,
                             CUICommandRegistry& cmd_reg);

/// A simplified version that adds commands applicable to a ISelectionClient,
/// the contributors are obtained from "scoped_objects::cmd_contributor"
void NCBI_GUICORE_EXPORT
    sAddScopedObjectCommands(wxMenu& menu,
                             vector<wxEvtHandler*>& handlers,
                             ISelectionClient& obj_provider,
                             CUICommandRegistry& cmd_reg);

END_NCBI_SCOPE

#endif  /// GUI_CORE___VIEW_EXTENSIONS__HPP
