% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShiftingMethods.R
\name{shiftPromoter}
\alias{shiftPromoter}
\alias{shiftPromoter,TSSr-method}
\title{Select genes which have core promoter shift across different experiments.}
\usage{
shiftPromoter(object, comparePairs, pval=0.01)

\S4method{shiftPromoter}{TSSr}(object, comparePairs, pval = 0.01)
}
\arguments{
\item{object}{A TSSr object.}

\item{comparePairs}{Specified list of sample pairs for comparison.}

\item{pval}{Genes with adjusted p value >= pval will be returned. Default value = 0.01.}
}
\description{
Selects genes which have multiple core promoters and undergo core promoter
shifting across different experiments. Generates gene list with Ds (degree of shift)
value (Lu et al., 2019), p value and adjusted p value.
}
\examples{
\donttest{
shiftPromoter(exampleTSSr,comparePairs=list(c("control","treat")), pval = 0.01)
}
}
