% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapeMethods.R
\name{shapeCluster}
\alias{shapeCluster}
\alias{shapeCluster,TSSr-method}
\title{Analysis of core promoter shape}
\usage{
shapeCluster(object, clusters = "consensusClusters", method = "PSS",
 useMultiCore=FALSE, numCores = NULL)

\S4method{shapeCluster}{TSSr}(
  object,
  clusters = "consensusClusters",
  method = "PSS",
  useMultiCore = FALSE,
  numCores = NULL
)
}
\arguments{
\item{object}{A TSSr object.}

\item{clusters}{Clusters to be used for calculating shape score: "tagClusters" or "consensusClusters".
Default is "consensusClusters".}

\item{method}{Method to be used for calculating core promoter shape score: "SI" or "PSS". Default is "PSS".}

\item{useMultiCore}{Logical indicating whether multiple cores are used (TRUE) or not (FALSE). Default is FALSE.}

\item{numCores}{Number of cores are used in clustering step. Used only if useMultiCore = TRUE. Default is NULL.}
}
\description{
Calculates core promoter shape based on the distributions of TSSs within core
 promoters using Shape Index (SI) algorithm (Hoskins et al. 2011) or Promoter Shape Score (PSS)
  algorithm (Lu et al. 2019).
}
\examples{
\donttest{
	shapeCluster(exampleTSSr,clusters = "consensusClusters" , method = "PSS")
	shapeCluster(exampleTSSr,clusters = "tagClusters" , method = "SI")
}
}
