% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportMethods.R
\name{plotTSS}
\alias{plotTSS}
\alias{plotTSS,TSSr-method}
\title{Plot TSSs and clusters}
\usage{
plotTSS(object,samples,tssData = "processed",clusters = "assigned",
clusterThreshold = 0.02,genelist,Bidirection = TRUE,up.dis =500,down.dis = 500)

\S4method{plotTSS}{TSSr}(
  object,
  samples,
  tssData = "processed",
  clusters = "assigned",
  clusterThreshold = 0.02,
  genelist,
  Bidirection = TRUE,
  up.dis = 500,
  down.dis = 500
)
}
\arguments{
\item{object}{A TSSr object.}

\item{samples}{Specify samples to be included for plotting.}

\item{tssData}{Specify which TSS data to be included for plotting: "raw" or "processed".}

\item{clusters}{Specify which cluster data to be included for plotting: "all" or "assigned".}

\item{clusterThreshold}{Ignore downstream clusters if signal < filterClusterThreshold*the strongest
clusters within the same gene promoter region. Default value = 0.02.}

\item{genelist}{List of gene names used for plotting.}

\item{Bidirection}{Specify whether to display bidirectional TSS signals within defined region. Default is TRUE.}

\item{up.dis}{Distance upstream of genes to specify plotting range. Default value = 500.}

\item{down.dis}{Distance downstream of genes to specify plotting range. Default value = 500.}
}
\description{
Plots Gviz-track of TSSs, clusters, and genes.
}
\examples{
\donttest{
plotTSS(exampleTSSr, samples=c("control","treat"), genelist=c("YBL017C","YBL067C")
,up.dis =500, down.dis = 500)
}
}
