% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportMethods.R
\name{plotDE}
\alias{plotDE}
\alias{plotDE,TSSr-method}
\title{Plot gene differential expressions}
\usage{
plotDE(object, withGeneName = "TRUE",xlim, ylim)

\S4method{plotDE}{TSSr}(object, withGeneName = "TRUE", xlim = c(-2.5, 2.5), ylim = c(0, 10))
}
\arguments{
\item{object}{A TSSr object.}

\item{withGeneName}{Specify whether to display names for genes which are differentially expressed. Default is "TRUE".}

\item{xlim}{Only enes of which log2FoldChange value within the xlim range are plotted. Default xlim = c(-2.5, 2.5).}

\item{ylim}{Only genes of which -log10(pvalue) within the ylim range are plotted. Default ylim = c(0, 10).}
}
\description{
Vocano plots of gene differential expression (with DESeq2 method) results.
}
\examples{
\donttest{
plotDE(exampleTSSr, withGeneName = "TRUE")
plotDE(exampleTSSr, withGeneName = "FALSE")
}
}
