% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportMethods.R
\name{exportTSStoBedgraph}
\alias{exportTSStoBedgraph}
\alias{exportTSStoBedgraph,TSSr-method}
\title{Creating Bedgraph/BigWig tracks of TSSs}
\usage{
exportTSStoBedgraph(object, data = "processed", format = "bedGraph",oneFile = FALSE)

\S4method{exportTSStoBedgraph}{TSSr}(
  object,
  data = "processed",
  format = "bedGraph",
  oneFile = FALSE
)
}
\arguments{
\item{object}{A TSSr object.}

\item{data}{Specify which data will be exported: "raw" or "processed". Default is "processed".}

\item{format}{The format of output files: "bedGraph" or "BigWig". Default is "bedGraph".}

\item{oneFile}{Logical, specify whether to export individual TSS tracks into the one bedGraph
file (TRUE) of in separate bedGraph files (FALSE).}
}
\description{
Creates bedGraph/BigWig files of TSSs that can be visualized in the UCSC Genome Browser
 and Integrative Genomics Viewer (IGV).
}
\examples{
\donttest{
exportTSStoBedgraph(exampleTSSr, data = "processed", format = "bedGraph")
}
}
