% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionMethods.R
\name{deGene}
\alias{deGene}
\alias{deGene,TSSr-method}
\title{Analysis of gene differential expression.}
\usage{
deGene(object,comparePairs=list(c("control","treat")), pval = 0.01,
 useMultiCore=FALSE, numCores = NULL)

\S4method{deGene}{TSSr}(
  object,
  comparePairs = list(c("control", "treat")),
  pval = 0.01,
  useMultiCore = FALSE,
  numCores = NULL
)
}
\arguments{
\item{object}{A TSSr object.}

\item{comparePairs}{Specified list of sample pairs for comparison with DESeq2 method.}

\item{pval}{Genes with adjusted p value >= pVal will be returned. Default value = 0.01.}

\item{useMultiCore}{Logical indicating whether multiple cores are used (TRUE) or not (FALSE). Default is FALSE.}

\item{numCores}{Number of cores are used in clustering step. Used only if useMultiCore = TRUE. Default is NULL.}
}
\description{
Analyzes gene-level differential expression using DESeq2 method (Love et al., 2014).
}
\examples{
\donttest{
deGene(exampleTSSr,comparePairs=list(c("control","treat")), pval = 0.01)
}
}
