% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConsensusMethods.R
\name{consensusCluster}
\alias{consensusCluster}
\alias{consensusCluster,TSSr-method}
\title{Make consensus clusters across multiple samples.}
\usage{
consensusCluster(object, dis = 50
, useMultiCore=TRUE, numCores = NULL)

\S4method{consensusCluster}{TSSr}(object, dis = 50, useMultiCore = TRUE, numCores = NULL)
}
\arguments{
\item{object}{A TSSr object.}

\item{dis}{Minimum distance between two peaks to be aggregated together into the same consensus cluster.}

\item{useMultiCore}{Logical indicating whether multiple cores are used (TRUE) or not (FALSE). Default is FALSE.}

\item{numCores}{Number of cores are used in clustering step. Used only if useMultiCore = TRUE. Default is NULL.}
}
\description{
Makes consensus clusters from multiple samples in TSSr object and calculates
inter-quantile positions within consensus clusters for each sample.
}
\examples{
\donttest{
consensusCluster(exampleTSSr,useMultiCore=FALSE)
}
}
