% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{print.bioCond}
\alias{print.bioCond}
\title{Print a \code{bioCond} Object}
\usage{
\method{print}{bioCond}(x)
}
\arguments{
\item{x}{A \code{\link{bioCond}} object.}
}
\value{
The function returns its argument invisibly.
}
\description{
This function prints its argument, which is a \code{\link{bioCond}} object,
and returns it invisibly (via \code{\link[base]{invisible}(x)}).
}
\details{
This function implements the \code{\link[base]{print}} method for the
\code{"\link{bioCond}"} class.
}
\examples{
data(H3K27Ac, package = "MAnorm2")
attr(H3K27Ac, "metaInfo")

## Print bioConds that correspond to individuals.

# Perform the MA normalization and construct bioConds to represent
# individuals.
norm <- normalize(H3K27Ac, 4, 9)
norm <- normalize(norm, 5:6, 10:11)
norm <- normalize(norm, 7:8, 12:13)
conds <- list(GM12890 = bioCond(norm[4], norm[9], name = "GM12890"),
              GM12891 = bioCond(norm[5:6], norm[10:11], name = "GM12891"),
              GM12892 = bioCond(norm[7:8], norm[12:13], name = "GM12892"))
autosome <- !(H3K27Ac$chrom \%in\% c("chrX", "chrY"))
conds <- normBioCond(conds, common.peak.regions = autosome)

# Print these bioConds.
print(conds[[1]])
print(conds[[2]])
print(conds[[3]])
}
\seealso{
\code{\link{bioCond}} for creating a \code{bioCond} object.
}
