#include <math.h>

double gammln(double xx)					// returns ln[Gamma[xx]] for xx > 0
{
	double x,tmp,ser;
	static double cof[6]={76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.120858003e-2,
		-0.536382e-5};
	int j;
	x = xx-1.0;
	tmp = x+5.5;
	tmp -= (x+0.5)*log(tmp);
	ser = 1.0;
	for (j=0; j<=5; j++) {
		x += 1.0;
		ser += cof[j]/x;
	}
	return -tmp+log(2.50662827465*ser);
}

double factln(int n)					// returns ln(n!)
{
	static double a[101];
	if (n <= 1) return 0.0;
	if (n <= 100) return a[n] ? a[n] : (a[n]=gammln(n+1.0));
	else return gammln(n+1.0);
} 

double bico(int n, int k)			// returns binomial coefficients (nCk)
{
	if (k == 1) return n;
	if (k == 0) return 1.0;
	else return floor(0.5+exp(factln(n)-factln(k)-factln(n-k)));
}















