% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runLDmixtureModel.R
\name{runLDmixtureModel}
\alias{runLDmixtureModel}
\title{Run LDmixtureModel to a dataset}
\usage{
runLDmixtureModel(
  haplos,
  annot,
  blockSize = 2,
  distance = 10000,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{haplos}{Matrix with the haplotypes (SNPs in columns, samples in rows)}

\item{annot}{GenomicRanges with the SNPs annotation}

\item{blockSize}{Numeric with the size of the SNP block (Default: 2)}

\item{distance}{Numeric with the maximum distance in bases to pair two blocks. (Default: 1e5)}

\item{BPPARAM}{An object from \code{BiocParallelParam}. It allow running the models
in parallel. By default, the models are run in serial.}
}
\value{
A list with the results of the LDmixture models. Each element is a model
and contains the following items:
\itemize{
 \item{"logMix"}{Log-likelihood of mixture model}
 \item{"logLD"}{Log-likelihood of linkage model}
 \item{"logNoLD"}{Log-likelihood of recomb model}
 \item{"BIC"}{BIC of the mixture vs the base model}
 \item{"prob"}{Proportion of chromosomes belonging to recomb model}
 \item{"steps"}{Number of iterations until converge of the EM algorithm}
 \item{"pval"}{P-value of the Chi-square test}
 \item{"r1"}{Responsibilities for recomb population of each chromosomes.}
}
}
\description{
This function makes SNP-blocks and pair them. Then, it applies LDmixtureModel
to all SNP-block pairs closer than a selected distance.
}
