% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LDmixtureModel}
\alias{LDmixtureModel}
\title{Run LDmixture model to a pair of SNP-blocks}
\usage{
LDmixtureModel(dat, maxSteps = NULL, prob0 = NULL, blocksize = NULL)
}
\arguments{
\item{dat}{Matrix with the genotype data}

\item{maxSteps}{Numerical with the maximum number of iterations run by the EM algorithm}

\item{prob0}{Initial mixture probability.}
}
\value{
A list with the LDmixture results
\itemize{
 \item{"logMix"}{Log-likelihood of mixture model}
 \item{"logLD"}{Log-likelihood of linkage model}
 \item{"logNoLD"}{Log-likelihood of recomb model}
 \item{"BIC"}{BIC of the mixture vs the base model}
 \item{"prob"}{Proportion of chromosomes belonging to recomb model}
 \item{"steps"}{Number of iterations until converge of the EM algorithm}
 \item{"pval"}{P-value of the Chi-square test}
 \item{"r1"}{Responsibilities for recomb population of each chromosomes. It is
 only available for selected models (BIC > 10, pval > 0.05)}
}
}
\description{
Run LDmixture model to a pair of SNP-blocks
}
