# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Run LDmixture model to a pair of SNP-blocks
#'
#' @param dat Matrix with the genotype data
#' @param maxSteps Numerical with the maximum number of iterations run by the EM algorithm
#' @param prob0 Initial mixture probability.
#' @return A list with the LDmixture results
#' \itemize{
#'  \item{"logMix"}{Log-likelihood of mixture model}
#'  \item{"logLD"}{Log-likelihood of linkage model}
#'  \item{"logNoLD"}{Log-likelihood of recomb model}
#'  \item{"BIC"}{BIC of the mixture vs the base model}
#'  \item{"prob"}{Proportion of chromosomes belonging to recomb model}
#'  \item{"steps"}{Number of iterations until converge of the EM algorithm}
#'  \item{"pval"}{P-value of the Chi-square test}
#'  \item{"r1"}{Responsibilities for recomb population of each chromosomes. It is
#'  only available for selected models (BIC > 10, pval > 0.05)}
#' }
#' @export
LDmixtureModel <- function(dat, maxSteps = NULL, prob0 = NULL, blocksize = NULL) {
    .Call('_recombClust_LDmixtureModel', PACKAGE = 'recombClust', dat, maxSteps, prob0, blocksize)
}

