% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{generatePeriodicityTrack}
\alias{generatePeriodicityTrack}
\title{Core function to generate a track of periodicity strenght of a given 
dinucleotide at a given frequency, over a set of chosen GRanges.}
\usage{

  generatePeriodicityTrack(genome = Biostrings::getSeq(BSgenome.Celegans.UCSC.ce11::BSgenome.Celegans.UCSC.ce11),
  granges, MOTIF = "WW", EXTEND.GRANGES = 1000,
  GENOME.WINDOW.SIZE = 100, GENOME.WINDOW.SLIDING = 2,
  BIN.WINDOW.SIZE = 60, BIN.WINDOW.SLIDING = 5,
  RANGE.FOR.SPECTRUM = 1:50, FREQ = 1/10, PROCS = 12,
  bw.file = NULL)
}
\arguments{
\item{genome}{DNAStringSet object. Ideally, the sequence of an entire genome, 
obtained for instance by running 
\code{Biostrings::getSeq(BSgenome.Celegans.UCSC.ce11::BSgenome.Celegans.UCSC.ce11)}.}

\item{granges}{GRanges object (with seqnames overlapping the names of genome).}

\item{MOTIF}{String Oligonucleotide of interest.}

\item{EXTEND.GRANGES}{Integer The width the GRanges are going to 
be extended to (default 1000).}

\item{GENOME.WINDOW.SIZE}{Integer The width of the bins to split the GRanges
objects in (default 100).}

\item{GENOME.WINDOW.SLIDING}{Integer The increment between bins over GRanges
(default 2).}

\item{BIN.WINDOW.SIZE}{Integer The width of the bins to split each primary bin
in (default 60).}

\item{BIN.WINDOW.SLIDING}{Integer The increment between secondary bins
(default 5).}

\item{RANGE.FOR.SPECTRUM}{Numeric vector The distances between nucleotides
to take into consideration when performing Fast Fourier Transform (default 1:50).}

\item{FREQ}{Float The frequence of the dinucleotide to study (default 1/10).}

\item{PROCS}{Integer Split the workload over several processors (default 12).}

\item{bw.file}{String. The name of the output bigWig track}
}
\value{
NULL A bigWig track in the working directory.
}
\description{
Core function to generate a track of periodicity strenght of a given 
dinucleotide at a given frequency, over a set of chosen GRanges.
}
