% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmat.R
\name{plotVmat.list}
\alias{plotVmat.list}
\title{A function to plot a list of Vmats}
\usage{
\method{plotVmat}{list}(list_params, cores = 1, XAXIS.CUTOFF = 1000,
  YAXIS.CUTOFF = 1000, stranded = TRUE, normalize = TRUE,
  Vmat2 = NULL, estimate_background = TRUE,
  background_granges = NULL, normFun = "pctsum", roll = 3,
  return_Vmat = FALSE, genome = "ce11", verbose = TRUE, ...)
}
\arguments{
\item{list_params}{list Each element of the list should be a list, containing
the bam_granges as the first sub-element and the granges as the 
second sub-element. Can accept the background_granges as a third sub-element.}

\item{XAXIS.CUTOFF}{single integer. The x limits (-/+) of the computed Vmat}

\item{YAXIS.CUTOFF}{single integer. The y upper limit of the computed Vmat}

\item{stranded}{Boolean. Should the Vmat be stranded? If TRUE, negative-strand 
features are flipped}

\item{normalize}{Boolean Should the Vmat be normalized?}

\item{Vmat2}{table A Vmat pre-computed over a background}

\item{estimate_background}{Boolean Should the background be estimated automatically?}

\item{background_granges}{GRanges The genomic loci used to compute the background Vmat}

\item{normFun}{string A Vmat can be scaled relative to its median ('pctmedian'), 
to its mean ('pctmean'), to its max ('pctmax'). Otherwise it could be zscore-d
entirely ('Zscore') or by rows ('rowZscore') or by columns ('colZscore').}

\item{roll}{integer to use as the window to smooth the Vmat rows by rolling mean}

\item{return_Vmat}{Boolean. Should the function return the computed Vmat 
rather than the plot?}

\item{genome}{a BSgenome object. See getChromSizes for more details}

\item{verbose}{Boolean}
}
\value{
A list of Vmat ggplots
}
\description{
A function to plot a list of Vmats
}
