#Maude Strobino (Steiner lab)
# Use to detect commons origins on two different dataset

library(data.table)
library(GenomicRanges)
library(readr)

Sample<-read_delim('/Path/To/Origins???',delim='\t',col_names = T)
Control<-read.delim('/Path/To/previously/Mapped/Origins', header = F)

Control$half <- round((Control$V2 + Control$V3) /2)
Sample$half <- round((Sample$start + Sample$end) /2)
#Create interval if necessary
Sample$start2 <- Sample$half - 5000
Sample$end2 <- Sample$half + 5000

Control$start <- Control$half - 5000
Control$end <- Control$half + 5000


Sample_Range <- GRanges(seqnames=Sample$`#chrom`, ranges=IRanges(start=Sample$start2, end=Sample$end2))
Control_Range <- GRanges(seqnames=Control$V1, ranges=IRanges(start=Control$start, end=Control$end))

Overlapps <-findOverlaps(Sample_Range,Control_Range)

#Give the list of origins from our sample present on the control
idx <- queryHits(Overlapps)
values <- Sample_Range[idx]


List<- data.frame(seqnames=seqnames(values),
                  starts=start(values),
                  ends=end(values))
