#Maude Strobino (Steiner Lab)

# Input: matrix obtain with PlotHeatmap in deeptools
# What: Obtain the enrichment to the peak compare to the background
# To complete: Matrix, which origins (early, late, dormant),
# size of the peaks (min and max). This last information is obtained by the script 6_Peaks_size.R


Matrix<-read.delim("/Path/To/Matrix", header = F)
row_early <- 3 + 182
row_late <- row_early + 616
row_dormant <- row_late + 312

Early_Matrix<-Matrix[4:row_early,] # Only early
Late_Matrix<-Matrix[(row_early+1):row_late,] # Only late
Dormant_Matrix<-Matrix[(row_late+1):row_dormant,] # Only dormant

######################################################## To complete

New_Matrix <- Dormant_Matrix


#convert the number to numeric value (instead of factor)
indx <- sapply(New_Matrix, is.factor)
New_Matrix[indx] <- lapply(New_Matrix[indx], function(x) as.numeric(as.character(x)))
a <- nrow(New_Matrix)


#Take all the value at peak position
New_Matrix[,102:103]<- NULL
peak <- ((ncol(New_Matrix)-1)/2)+1
enrichment <-as.data.frame(New_Matrix[,peak])
######################################################## To complete (use 6_Peaks_size.R to have the information)

peak_min <- peak-5
peak_max <- peak + 4

#Took random position on the matrix and assign the value
number <- nrow(enrichment)
enrichment$random <- 0
for (i in 1:number){
        line <-as.numeric(sample(1:nrow(New_Matrix), 1))
        col <- as.numeric(sample(1:ncol(New_Matrix), 1))
        while (col > peak_min && col < peak_max ) {
                col <- as.numeric(sample(1:ncol(New_Matrix), 1))
        }
        enrichment[i,2] <- New_Matrix[line,col]
}

meanPeak=mean(enrichment$`New_Matrix[, peak]`, na.rm = TRUE)
meanRandom=mean(enrichment$random, na.rm = TRUE)
Delta <- meanPeak - meanRandom
print(Delta)

