#Maude Strobino (Steiner Lab)

# Input: matrix obtain with PlotHeatmap in deeptools
# What: Obtain the width of the peaks
library(data.table) #data.table_1.9.5


Matrix<- read.delim("/Path/To/Matrix", header = F)
row_early <- 3 + 182
row_late <- row_early + 616
row_dormant <- row_late + 312

Early_Matrix<-Matrix[4:row_early,] # Only early
Late_Matrix<-Matrix[(row_early+1):row_late,] # Only late
Dormant_Matrix<-Matrix[(row_late+1):row_dormant,] # Only dormant

#### To complete
New_Matrix <- Late_Matrix

#convert the number to numeric value (instead of factor)
indx <- sapply(New_Matrix, is.factor)
New_Matrix[indx] <- lapply(New_Matrix[indx], function(x) as.numeric(as.character(x)))
a <- nrow(New_Matrix)
New_Matrix[102:103] <- NULL
Average <- as.data.frame(colMeans(New_Matrix, na.rm = TRUE))

#Create a new data frame with the positions
pos <- as.data.frame(seq(-50000, 50000, by=1000))

# Bind the position to the average
value <- cbind(pos,Average)

#Define background as average value not around the peak
sum <- 0
for (i in 1:11){
        sum <- sum + value[i,2]
}
for (i in 91:100){
        sum <- sum + value[i,2]
}
background <-sum/21

# Define peak hight
peak_hight <-value[51,2]
Max_Peak <- peak_hight-background
half_peak <- Max_Peak/2
treshold <- peak_hight - half_peak

##Find the first location higher than half peak
min <- 0
for (i in 51 :1){
        if ((value[i,2]) < treshold){
                break
        }
        
}
min <- value[i+1,1]

#Find the last location higher than half peak
max <- 0
for (i in 51:100){
        if ((value[i,2]) < treshold){
                break
        }
        
}
max <- value[i-1,1]
Peak_width <- max - min
print(Peak_width)

