#Maude Strobino (Steiner lab)

# Use to remove duplicated peaks when merging different lists of peak

library(data.table)
library(GenomicRanges)
library(readr)

peaks1<- read.delim('Path/to/peaks_1.bed',header = F) # Peaks from CDT-1 ChEC-seq
peaks2 <- read.delim('Path/to/peaks_2.bed', header = F) # Peaks from TRES1 ChEC-seq
peaks3 <- read.delim ('Path/to/peaks_3.bed', header = F) # Peaks from EdU-seq


#Create interval
peaks2$middle <- round((peaks2$V2 + peaks2$V3)/2)
peaks2$start <- peaks2$middle - 5000
peaks2$end <- peaks2$middle + 5000

peaks1$middle <- round((peaks1$V2 + peaks1$V3)/2)
peaks1$start <- peaks1$middle - 5000
peaks1$end <- peaks1$middle + 5000

peaks3$middle <- round((peaks3$V2 + peaks3$V3)/2)
peaks3$start <- peaks3$middle - 5000
peaks3$end <- peaks3$middle + 5000

peaks2_Range <- GRanges(seqnames=peaks2$V1, ranges=IRanges(start=peaks2$start, end=peaks2$end))
peaks1_Range <- GRanges(seqnames=peaks1$V1, ranges=IRanges(start=peaks1$start, end=peaks1$end))
peaks3_Range <- GRanges(seqnames=peaks3$V1, ranges=IRanges(start=peaks3$start, end=peaks3$end))

# Find peaks from peaks 2 that overlap from peaks in peaks 1

hits <-findOverlaps(peaks2_Range, peaks1_Range)
commun_peaks <- peaks2[queryHits(hits),]
#Remove these peaks from peaks2
peaks2_new <- peaks2[!(peaks2$V2 %in% commun_peaks$V2),]
# Bind peaks1 and new_peaks2
Peaks_semi_final <- rbind(peaks1, peaks2_new)
peaks_semi_final_Range <- GRanges(seqnames=Peaks_semi_final$V1, ranges=IRanges(start=Peaks_semi_final$start, end=Peaks_semi_final$end))



# Find peaks from peaks 3 that overlap from peaks in peaks_semi_final

hits2 <-findOverlaps(peaks3_Range, peaks_semi_final_Range)
commun_peaks2 <- peaks3[queryHits(hits2),]
#Remove these peaks from peaks3
peaks3_new <- peaks3[!(peaks3$V2 %in% commun_peaks2$V2),]
# Bind peaks1 and new_peaks2
Peaks_final <- rbind(Peaks_semi_final, peaks3_new)

Peaks_final<- Peaks_final[,c(1:5)]



write.table(Peaks_final,'Path/to/output.bed',sep = "\t", row.names = FALSE, col.names = F, quote=F )
