# Maude Strobino (Steiner lab)
# Smooth the genomic data

# This script has to be used in the terminal.
# Choose parameters according to what you need.
# Input and output = Bed files

#options(echo=TRUE)
args <- commandArgs(trailingOnly = T)
if (length(args)!=4) { print('[1] PATH to the folder containing the BED file to smooth [2] Name of your BED file
                             [3] Name for your output file (without extension) [4] smoothing method
                             1 sliding windows 5
                             2 sliding windows 5 and weight
                             3 sliding windows 9
                             4 sliding windows 13')
        
} else {
        
        
        
        #       Part 1. Parameters
        path <-args[1]
        file <-args[2]
        name <- args[3]
        n <- args[4]
        
        
        
        
        
        #########################################
        Bed <- read.delim(paste(path,'/',file, sep=''), header = F)
        Bed <- Bed[-c(1),]
        chr <- split(Bed,Bed$V1) # split your file per chromosome
        
        
        if (n == 1) {
                Smooth_data = list()
                for (i in 1:7){
                        a <- i
                        chrN <-names(chr[a])
                        Data2 <- as.data.frame(chr[a])
                        Data2$smooth <- 0 # Create a new column where the smooth data will be putted
                        for (line in 3:as.numeric(nrow(Data2)-2)) # the value will be the average of 2 data before and 2 data after
                                Data2[line,5] <- (Data2[line-2,4] + Data2[line-1,4] + Data2[line,4] + Data2[line+1,4] + Data2[line+2,4])/5
                        for (line in 1:2)
                                Data2[line,5] <- Data2[line,4]
                        for (line in as.numeric(nrow(Data2)-1):as.numeric(nrow(Data2)))
                                Data2[line,5] <- Data2[line,4]
                        
                        names(Data2) <- c('chr', 'start', 'end', 'value', 'smooth')
                        Data2$value <- NULL
                        
                        Smooth_data[[i]] <- Data2
                }
                
                smooth_data_final = do.call(rbind, Smooth_data)
                smooth_data_final<- rbind(data.frame(chr ='track type=bedGraph  visibility=full  yLineOnOff=on   autoScale=on    yLineMark="0.0"  alwaysZero=on  graphType=bar   maxHeightPixels=128:75:11       windowingFunction=maximum       smoothingWindow=off', start ='', end='',smooth='',stringsAsFactors=FALSE ),smooth_data_final)
                write.table(smooth_data_final, paste(path,name,'_smoothed_wind5.bed', sep=''), sep="\t", row.names = FALSE, col.names = F, quote = F)
                
        }
        
        
        
        if (n==2) {
                Smooth_data_weight = list()
                for (i in 1:7){
                        a <- i
                        chrN <-names(chr[a])
                        Data2 <- as.data.frame(chr[a])
                        Data2$smooth <- 0 # Create a new column where the smooth data will be putted
                        for (line in 3:as.numeric(nrow(Data2)-2)) # the value will be the average of 2 data before and 2 data after and also weight differently according to their position
                                Data2[line,5] <- (Data2[line-2,4] + 2*(Data2[line-1,4]) + 3*(Data2[line,4]) + 2*(Data2[line+1,4]) + Data2[line+2,4])/9
                        for (line in 1:2)
                                Data2[line,5] <- Data2[line,4]
                        for (line in as.numeric(nrow(Data2)-1):as.numeric(nrow(Data2)))
                                Data2[line,5] <- Data2[line,4]
                        
                        names(Data2) <- c('chr', 'start', 'end', 'value', 'smooth')
                        Data2$value <- NULL
                        
                        
                        Smooth_data_weight[[i]] <- Data2
                        
                }
                
                smooth_data_weight_final = do.call(rbind, Smooth_data_weight)
                smooth_data_weight_final<- rbind(data.frame(chr ='track type=bedGraph  visibility=full  yLineOnOff=on   autoScale=on    yLineMark="0.0"  alwaysZero=on  graphType=bar   maxHeightPixels=128:75:11       windowingFunction=maximum       smoothingWindow=off', start ='', end='',smooth='',stringsAsFactors=FALSE ),smooth_data_weight_final)
                write.table(smooth_data_weight_final, paste(path,name,'_smoothed_weight.bed', sep=''), sep="\t", row.names = FALSE, col.names = F, quote = F)
                
        }
        
        
        
        if (n ==3){
                Smooth_data_9 = list()
                for (i in 1:7){
                        a <- i
                        chrN <-names(chr[a])
                        Data2 <- as.data.frame(chr[a])
                        Data2$smooth <- 0 # Create a new column where the smooth data will be putted
                        for (line in 5:as.numeric(nrow(Data2)-4)) # the value will be the average of 2 data before and 2 data after
                                Data2[line,5] <- (Data2[line-4,4] + Data2[line-3,4]+Data2[line-2,4]+ Data2[line-1,4] + Data2[line,4] + Data2[line+1,4] + Data2[line+2,4]+ Data2[line+3,4] +  Data2[line+4,4] )/9
                        for (line in 1:4)
                                Data2[line,5] <- Data2[line,4]
                        for (line in as.numeric(nrow(Data2)-3):as.numeric(nrow(Data2)))
                                Data2[line,5] <- Data2[line,4]
                        
                        names(Data2) <- c('chr', 'start', 'end', 'value', 'smooth')
                        Data2$value <- NULL
                        
                        Smooth_data_9[[i]] <- Data2
                }
                
                smooth_data_9_final = do.call(rbind, Smooth_data_9)
                smooth_data_9_final<- rbind(data.frame(chr ='track type=bedGraph  visibility=full  yLineOnOff=on   autoScale=on    yLineMark="0.0"  alwaysZero=on  graphType=bar   maxHeightPixels=128:75:11       windowingFunction=maximum       smoothingWindow=off', start ='', end='',smooth='',stringsAsFactors=FALSE ),smooth_data_9_final)
                write.table(smooth_data_9_final, paste(path,name,'_smoothed_wind9.bed', sep=''), sep="\t", row.names = FALSE, col.names = F, quote = F)
                
                
        }
        
        if (n ==4){
                Smooth_data_13 = list()
                for (i in 1:7){
                        a <- i
                        chrN <-names(chr[a])
                        Data2 <- as.data.frame(chr[a])
                        Data2$smooth <- 0 # Create a new column where the smooth data will be putted
                        for (line in 7:as.numeric(nrow(Data2)-6)) # the value will be the average of 2 data before and 2 data after
                                Data2[line,5] <- (Data2[line-6,4]+ Data2[line-5,4]+ Data2[line-4,4] + Data2[line-3,4]+Data2[line-2,4]+ Data2[line-1,4] +
                                                          Data2[line,4] + Data2[line+1,4] + Data2[line+2,4]+ Data2[line+3,4] +  Data2[line+4,4] + Data2[line+5,4] + Data2[line+6,4]) /13
                        for (line in 1:6)
                                Data2[line,5] <- Data2[line,4]
                        for (line in as.numeric(nrow(Data2)-5):as.numeric(nrow(Data2)))
                                Data2[line,5] <- Data2[line,4]
                        
                        names(Data2) <- c('chr', 'start', 'end', 'value', 'smooth')
                        Data2$value <- NULL
                        
                        Smooth_data_13[[i]] <- Data2
                }
                
                smooth_data_13_final = do.call(rbind, Smooth_data_13)
                smooth_data_13_final<- rbind(data.frame(chr ='track type=bedGraph  visibility=full  yLineOnOff=on   autoScale=on    yLineMark="0.0"  alwaysZero=on  graphType=bar   maxHeightPixels=128:75:11       windowingFunction=maximum       smoothingWindow=off', start ='', end='',smooth='',stringsAsFactors=FALSE ),smooth_data_13_final)
                write.table(smooth_data_13_final, paste(path,name,'_smoothed_wind13.bed', sep=''), sep="\t", row.names = FALSE, col.names = F, quote = F)
                
                
        }
        
        
        if (n ==5){
                Smooth_data_9 = list()
                for (i in 1:7){
                        a <- i
                        chrN <-names(chr[a])
                        Data2 <- as.data.frame(chr[a])
                        Data2$smooth <- 0 # Create a new column where the smooth data will be putted
                        for (line in 5:as.numeric(nrow(Data2)-4)) # the value will be the average of 2 data before and 2 data after
                                Data2[line,5] <- (Data2[line-4,4] + 2*Data2[line-3,4]+3*Data2[line-2,4]+ 4*Data2[line-1,4] + 5*Data2[line,4] + 4*Data2[line+1,4] + 3*Data2[line+2,4]+ 2*Data2[line+3,4] +  Data2[line+4,4] )/25
                        for (line in 1:4)
                                Data2[line,5] <- Data2[line,4]
                        for (line in as.numeric(nrow(Data2)-3):as.numeric(nrow(Data2)))
                                Data2[line,5] <- Data2[line,4]
                        
                        names(Data2) <- c('chr', 'start', 'end', 'value', 'smooth')
                        Data2$value <- NULL
                        
                        Smooth_data_9[[i]] <- Data2
                }
                
                smooth_data_9_final = do.call(rbind, Smooth_data_9)
                smooth_data_9_final<- rbind(data.frame(chr ='track type=bedGraph  visibility=full  yLineOnOff=on   autoScale=on    yLineMark="0.0"  alwaysZero=on  graphType=bar   maxHeightPixels=128:75:11       windowingFunction=maximum       smoothingWindow=off', start ='', end='',smooth='',stringsAsFactors=FALSE ),smooth_data_9_final)
                write.table(smooth_data_9_final, paste(path,name,'_smoothed_weight_wind9.bed', sep=''), sep="\t", row.names = FALSE, col.names = F, quote = F)
                
                
        }
        
        
}        



