/*
 * peptide_result_parser.cpp
 *
 *  Created on: 8 mars 2013
 *      Author: valot
 */

#include "peptide_result_parser.h"
#include <QDebug>

PeptideResultParser::PeptideResultParser(GpEngine* engine) :
    _engine(engine), _firstElement(true) {
}

PeptideResultParser::~PeptideResultParser() {

}

bool PeptideResultParser::startElement(const QString & namespaceURI,
                                       const QString & localName, const QString & qName,
                                       const QXmlAttributes & attributes) {
    if (_firstElement) {
        _firstElement = false;
        if (qName != "peptide_result")
            throw new GpError(QString("The input is not a peptide result file"));
    } else if (qName == "sample") {
        _p_currentSample = _engine->getSampleInstance(attributes.value("name"));
        _p_currentSample->addFile(attributes.value("file"));
        qDebug() << "New Sample to read : " << _p_currentSample->getName();
    } else if (qName == "scan") {
        _currentScan = attributes.value("num").toInt();
        _currentCharge = attributes.value("z").toInt();
    } else if (qName == "psm") {
        _currentMH = attributes.value("mhTheo").toDouble();
        _currentSequence = attributes.value("seq");
        _p_currentPeptide = _engine->getPeptideInstance(_currentSequence, _currentMH);
        QString desc = attributes.value("prot");
        _p_currentProtein = _engine->getProteinMatchInstance(this->getAccessionTodesc(desc), desc);
    } else if (qName == "mod") {
        if(attributes.value("pm").isEmpty()) {
            _currentModifs += attributes.value("aa") + attributes.value("pos") + ":"
                              + attributes.value("mod") + " ";
        }
        else {
            _currentModifs += QString("pm@%1:%2=>%3 ").arg(attributes.value("pos")).arg(attributes.value("aa")).arg(attributes.value("pm"));
        }
    }
    _currentText = "";
    return true;
}

bool PeptideResultParser::endElement(const QString & namespaceURI,
                                     const QString & localName, const QString & qName) {
    if (qName == "psm") {
        //complete le peptide et la proteines
        _p_currentPeptide->addSequencesModifs(_currentSequence,
                                              _currentModifs.trimmed());
        _p_currentPeptide->addHashSampleScan(_p_currentSample, _currentScan,
                                             _currentCharge);
        _p_currentProtein->addPeptides(_p_currentPeptide);
        _currentSequence = "";
        _currentModifs = "";
    }
    return true;
}

bool PeptideResultParser::endDocument() {
    return true;
}

bool PeptideResultParser::startDocument() {
    return true;
}

bool PeptideResultParser::characters(const QString &str) {
    _currentText += str;
    return true;
}

bool PeptideResultParser::fatalError(const QXmlParseException &exception) {
    _errorStr = QObject::tr("Parse error at line %1, column %2:\n"
                            "%3").arg(exception.lineNumber()).arg(exception.columnNumber()).arg(exception.message());
    return false;
}

QString PeptideResultParser::errorString() const {
    return _errorStr;
}

QString PeptideResultParser::getAccessionTodesc(QString& desc) {
    return desc.split(" ").at(0);
}
