/*
*
* Protein Grouper
* Copyright (C) 2014 Olivier Langella, Benoit Valot, Michel Zivy.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "gp_types.h"
#include "identification/peptide_set.h"
#include "identification/protein_match.h"
#include "identification/peptide.h"
#include "grouping/sub_group_set.h"
#include "grouping/threadsafe_group_set.h"
#include <functional>
#include <QTextStream>
#include <QMutex>
#include <QList>

#ifndef PG_PROTSEQFILTERPEPTIDEORPHANS_H_
#define PG_PROTSEQFILTERPEPTIDEORPHANS_H_

/** @brief apply the protein grouper algorithm to a raw protein database (fasta format)
 *
 * */
class PgProtSeqFilterPeptideOrphans {
public:
	PgProtSeqFilterPeptideOrphans();
    virtual ~PgProtSeqFilterPeptideOrphans();
    void readInputStream();


private:
    void filterProteinMatch(ProteinMatch * p_protMatch);
    void removeOrphan(ProteinMatch * p_protMatch);
    void addOrphan(ProteinMatch * p_protMatch);

    Peptide * getPeptideInstance(QString seq, gp_double mh);

    ProteinMatch* getProteinMatchInstance(QString access, QString desc);

    std::map<Peptide*, ProteinMatch *> _orphanMap;

    std::map<QString, Peptide*> _peptideList;
    /* Unique peptide to all dataset*/
    std::map<QString, ProteinMatch*> _proteinMatchList;

    QTextStream* _p_out;

    bool _currentPmHasSomethingInCommon;
};


#endif /* PG_PROTSEQFILTERPEPTIDEORPHANS_H_ */
