/*
*
* Protein Grouper
* Copyright (C) 2014 Olivier Langella, Benoit Valot, Michel Zivy.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "pg_protseqfilterpeptideorphans.h"
#include "gp_error.h"
#include <QXmlSimpleReader>
#include <QXmlInputSource>
#include <QList>
#include <QtConcurrentMap>
#include <QDebug>
#include <cstdio>
#include <iostream>

#include "sax/protein_grouping_result.h"

PgProtSeqFilterPeptideOrphans::PgProtSeqFilterPeptideOrphans() {
	_p_out = new QTextStream(stdout, QIODevice::WriteOnly);
}

PgProtSeqFilterPeptideOrphans::~PgProtSeqFilterPeptideOrphans() {

}

void PgProtSeqFilterPeptideOrphans::readInputStream() {

	qDebug() << "Begin reading fasta";
	QTextStream* p_in = new QTextStream(stdin, QIODevice::ReadOnly);

	QString accession = "";
	QString description = "";
	QString sequence = "";
	//Search accession conta
	//QTextStream in(p_in);
	ProteinMatch * pm = 0;
	_currentPmHasSomethingInCommon = false;
	QString line = p_in->readLine();
	while (!p_in->atEnd()) {
		if (line.startsWith(">")) {
			if (pm != 0) {
				filterProteinMatch(pm);
			}
			sequence = "";
			_currentPmHasSomethingInCommon = false;
			accession = line.remove(0, 1);
			description = accession;
			QStringList elements = accession.split(" ");
			if (elements.size() > 0) {
				accession = elements.at(0);
			}
		} else {
			sequence += line;

			//create proteinMatch :
			pm = this->getProteinMatchInstance(accession,
					description);
			QStringList pepSeqList = sequence.split(" ");
			for (int i = 0; i < pepSeqList.size(); i++) {
				pm->addPeptides(
						this->getPeptideInstance(pepSeqList.at(i), 100));
			}
		}
		line = p_in->readLine();
	}
	if (pm != 0) {
		qDebug() << "PgProtSeqFilterPeptideOrphans::readInputStream " <<_currentPmHasSomethingInCommon;
		filterProteinMatch(pm);
	}
	//p_in->close();
}
void PgProtSeqFilterPeptideOrphans::removeOrphan(ProteinMatch * p_protMatch) {
	for (std::set<Peptide*>::const_iterator it = p_protMatch->getPeptideSet().getList().begin();
				it != p_protMatch->getPeptideSet().getList().end();it++) {
		_orphanMap.erase(*it);
	}
}
void PgProtSeqFilterPeptideOrphans::addOrphan(ProteinMatch * p_protMatch) {
	for (std::set<Peptide*>::const_iterator it = p_protMatch->getPeptideSet().getList().begin();
				it != p_protMatch->getPeptideSet().getList().end();it++) {
		_orphanMap.insert(std::pair<Peptide *, ProteinMatch *>(*it, p_protMatch));
	}
}
void PgProtSeqFilterPeptideOrphans::filterProteinMatch(
		ProteinMatch * p_protMatch) {
	qDebug() << "filterProteinMatch begin " << p_protMatch->getAccession();
	//1) check incoming protein match against list of orphans
	bool isOrphan = true;
	if (_currentPmHasSomethingInCommon) {
		isOrphan = false;
	}
	for (std::set<Peptide*>::const_iterator it = p_protMatch->getPeptideSet().getList().begin();
			it != p_protMatch->getPeptideSet().getList().end();it++) {
		std::map<Peptide*, ProteinMatch *>::iterator orphanIt = _orphanMap.find(*it);
		if (orphanIt != _orphanMap.end()) {
			qDebug() << p_protMatch->getAccession()
					<< " has peptides in common with " << orphanIt->second->getAccession();
			isOrphan = false;
			orphanIt->second->writeFastaPeptides(_p_out);
			removeOrphan(orphanIt->second);
		}
	}

	if (isOrphan) {
		addOrphan(p_protMatch);
	} else {
		p_protMatch->writeFastaPeptides(_p_out);
	}

}

ProteinMatch* PgProtSeqFilterPeptideOrphans::getProteinMatchInstance(
		QString access, QString desc) {
	std::map<QString, ProteinMatch*>::iterator it;
	it = this->_proteinMatchList.find(access);
	if (it != _proteinMatchList.end()) {
		//qDebug() << "Protein already exist : " + access;
		return it->second;
	} else {
		ProteinMatch* match = new ProteinMatch(access, desc);
		_proteinMatchList[access] = match;
		qDebug() << "New Protein : " + access;
		return match;
	}
}

Peptide * PgProtSeqFilterPeptideOrphans::getPeptideInstance(QString seq,
		gp_double mh) {
	std::map<QString, Peptide*>::iterator it;
	QString data = seq.replace("L", "I") + "|" + QString().setNum(mh, 'g', 8);
	it = this->_peptideList.find(data);
	if (it != _peptideList.end()) {
		qDebug() << "Peptide already exist : " + data;
		_currentPmHasSomethingInCommon = true;
		return it->second;
	} else {
		//qDebug() << "New Peptide : " + data;
		Peptide* pep = new Peptide(seq, mh);
		_peptideList[data] = pep;
		return pep;
	}
}
