/*
*
* Protein Grouper
* Copyright (C) 2014 Olivier Langella, Benoit Valot, Michel Zivy.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "pg_utils.h"
#include "gp_types.h"
#include "identification/peptide_set.h"
#include "identification/protein_match.h"
#include "identification/peptide.h"
#include "grouping/sub_group_set.h"
#include "grouping/threadsafe_group_set.h"
#include <functional>
#include <QTextStream>
#include <QMutex>
#include <QList>

#ifndef PG_PROTSEQENGINE_H_
#define PG_PROTSEQENGINE_H_

/** @brief apply the protein grouper algorithm to a raw protein database (fasta format)
 *
 * */
class PgProtSeqEngine {
public:
    PgProtSeqEngine();
    virtual ~PgProtSeqEngine();
    void triggerGrouping();

    Peptide * getPeptideInstance(QString seq);

    ProteinMatch* getProteinMatchInstance(QString access, QString desc);

    const GroupSet& getGroupSet()const {
        return groups;
    }
    
    void removeNonInformativeSubgroups(bool removeNonInformativeSubgroups) {
      this->_remove_non_informative_subgroups = removeNonInformativeSubgroups;
    }

private:
    void readInputStream();
    void performGrouping();
    void writeFastaGroupingOutputResult(QTextStream* p_out);
    void fillTmpSubgroups( SubGroupSet* p_subgroups);

    //function object
    //std::function<void (SubGroup* &)> checkInRemainingProteinList_f;

    void checkPeptideSetInRemainingProteinList(std::set<const ProteinMatch*> & proteinMatchSet, PeptideSet & peptides);
    void differProteinMatchListErase(const ProteinMatch* it);

    void deindexProteinMatch(const ProteinMatch * p_protMatch);
    void deindexPeptide(const Peptide* p_peptide);
    void indexProteinMatch(const ProteinMatch * p_protMatch);


    QMutex _mutex;
    std::list<const ProteinMatch*> _deleteLateProteinMatchIterator;
    std::list<const ProteinMatch*> _tmpProteinMatchList;

    std::map<QString, Peptide*> _peptideList;
    /* Unique peptide to all dataset*/
    std::map<QString, ProteinMatch*> _proteinMatchList;
    unsigned int _proteinMatchListSize;
    /* accession are used as key to retreived proteinMatch ref*/
    GroupSet groups;

    std::map<const Peptide*, std::list<const ProteinMatch*>> _mapPeptide2proteinMatch;
    
    bool _remove_non_informative_subgroups;
};


#endif /* GP_ENGINE_H_ */
