/*
 * protein_match.cpp
 *
 *  Created on: 8 mars 2013
 *      Author: valot
 */

#include "protein_match.h"
#include <QStringList>

ProteinMatch::ProteinMatch(QString access, QString desc) :
		_accession(access), _description(desc) {
}

ProteinMatch::~ProteinMatch() {
	// TODO Auto-generated destructor stub
}

void ProteinMatch::addPeptides(Peptide* pep) {
	_peptideSet.insert(pep);
}

void ProteinMatch::removePeptide(std::set<Peptide *>& peptidesToRemove) {
	_peptideSet.removeAll(peptidesToRemove);
}

unsigned int ProteinMatch::getUniquePeptide() const {
	std::set < QString > peptideSequence;

	for (std::set<Peptide *>::const_iterator peptideIt = _peptideSet.getList().begin();
			peptideIt != _peptideSet.getList().end(); peptideIt++) {
		peptideSequence.insert((*peptideIt)->getSequenceLi());
	}
	return (peptideSequence.size());
}

void ProteinMatch::writeFastaPeptides(QTextStream* p_out) const {
	*p_out << ">" << this->getDescription() << endl;
	for (std::set<Peptide *>::const_iterator peptideIt = _peptideSet.getList().begin();
			peptideIt != _peptideSet.getList().end(); peptideIt++) {
		*p_out << (*peptideIt)->getSequenceLi() << " ";
	}
	*p_out << endl << flush;

}

bool ProteinMatch::hasCommonPeptideWith(const ProteinMatch& protMatch) const {
	return this->_peptideSet.containsOnePeptideIn(protMatch._peptideSet);
}
