/*
 *
 * Protein Grouper
 * Copyright (C) 2014 Olivier Langella, Benoit Valot, Michel Zivy.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *

 * threadsafe_group_set.h
 *
 *  Created on: 22 mars 2013
 *      Author: valot
 */

#ifndef TS_GROUP_SET_H_
#define TS_GROUP_SET_H_

#include "group_set.h"

#include <functional>
#include <QMap>

#include <QMutex>

class TsGroupSet:public GroupSet {
public:
    TsGroupSet();
    virtual ~TsGroupSet();
    void groupingSubGroupList(const QList<SubGroup *> & qlSubgroups);

private:

  void deindexGroup(Group* p_group);
  void indexGroup(Group* p_group);
  void mapFusioningGroups(Group* p_fromgroup, Group* p_togroup);

    void tagFusioningGroups(Group* & p_group);
    //function object
    std::function<void (Group* &)> tagFusioningGroups_f;
    
    //map from original group pointer to all groups to fusion with
    QMap<Group*,QList<Group *>> _map_fusioning_groups;
    
    std::map<const Peptide*, Group *> _mapPeptide2group;

    QMutex _mutex;

};

#endif /* GROUP_SET_H_ */
