/*
 *
 * Protein Grouper
 * Copyright (C) 2014 Olivier Langella, Benoit Valot, Michel Zivy.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *

 * sub_group_set.h
 *
 *  Created on: 22 mars 2013
 *      Author: valot
 */

#ifndef SUB_GROUP_SET_H_
#define SUB_GROUP_SET_H_

#include <list>
#include "sub_group.h"
#include "../identification/protein_match.h"

class SubGroupSet {
public:
    SubGroupSet();
    virtual ~SubGroupSet();
    void addProteinMatch(const ProteinMatch * proteinMatch);
    void addSubGroup(SubGroup * subGroup);
    void removeSubGroup(SubGroup * subGroup);
    void clear() {
        _subgroups.clear();
	_mapPeptide2subGroup.clear();
	_subgroupOrder.clear();
    }

    inline void addAll(const SubGroupSet& sgSet) {
        _subgroups.insert(_subgroups.end(), sgSet._subgroups.begin(), sgSet._subgroups.end());
    }

    const std::list<SubGroup *> & getSubgroups() const;

    void indexAndOrderSubGroup();

    const std::vector<SubGroup *> & getOrderedSubgroups() const;

    unsigned int size()const {
        return(_subgroups.size());
    }
    QString getFirstAccession() const;

private:
    void fillSgSet(std::set<SubGroup *> & subGroupListCheck, const std::set<Peptide *> & peptideList);
    void deindexPeptide2SubGroup(const SubGroup * p_sg);

    bool indexPeptide2SubGroup(SubGroup * p_sg) ;

    std::map<const Peptide*, std::set<SubGroup*>>  _mapPeptide2subGroup;

    std::list<SubGroup *> _subgroups;
    std::vector<SubGroup *> _subgroupOrder;
};

#endif /* SUB_GROUP_SET_H_ */
