/*
 * sub_group.h
 *
 *  Created on: 22 mars 2013
 *      Author: valot
 */

#ifndef SUB_GROUP_H_
#define SUB_GROUP_H_

#include "../identification/peptide_set.h"
#include "../identification/protein_match.h"
#include <QDebug>

class SubGroup {
public:
    SubGroup(const ProteinMatch * proteinMatch);
    virtual ~SubGroup();
    bool addProteinMatch(const ProteinMatch * proteinMatch);
    void indexAndOrderProteinMatch();
    const PeptideSet& getPeptideSet()const {
        return(_peptideSet);
    }

    const QString getOrderString() const;

    const QString getNonInformativeOrderString() const;

    QString getFirstAccession() const;

    const std::vector<const ProteinMatch *> & getOrderedProteinMatchs() const;

    unsigned int getNumberOfProteinMatch() const {
        return _proteinMatchSet.size();
    }
    unsigned int getNumberOfOrderedProteinMatch() const {
        return _proteinMatchOrder.size();
    }
    void debugPeptide() const {
        qDebug() << "debugPeptide subgroup " << this;
        for (std::set<Peptide*>::const_iterator i=_peptideSet.getList().begin(); i != _peptideSet.getList().end(); i++) {
            qDebug() << (*i)->getSequenceLi();
        }
    }
    void debugProtein() const {
        for (std::set<const ProteinMatch*>::const_iterator i=_proteinMatchSet.begin(); i != _proteinMatchSet.end(); i++) {
            qDebug() << (*i)->getAccession();
        }
    }
private:
    PeptideSet _peptideSet;
    std::set<const ProteinMatch*> _proteinMatchSet;
    std::vector<const ProteinMatch*> _proteinMatchOrder;
};
#endif /* SUB_GROUP_H_ */
