/*
 * sub_group.cpp
 *
 *  Created on: 22 mars 2013
 *      Author: valot
 */

#include "sub_group.h"

#include "../gp_error.h"
#include "../pg_utils.h"

SubGroup::SubGroup(const ProteinMatch * proteinMatch) {
	_peptideSet.addAll(proteinMatch->getPeptideSet());
	_proteinMatchSet.insert(proteinMatch);
}

SubGroup::~SubGroup() {
	qDebug() << "SubGroup::~SubGroup begin " << this ;
	_proteinMatchOrder.clear();
	_proteinMatchSet.clear();
}


const QString SubGroup::getOrderString() const {

	QString index = PgUtils::getLexicalOrderedString(this->getPeptideSet().getTotalSpectra());
	index.append(PgUtils::getLexicalOrderedString(_proteinMatchSet.size()));
	//qDebug() << "QString SubGroup::getOrderString() " << index;
	return index;
}

const QString SubGroup::getNonInformativeOrderString() const {
	//sg->getPeptideSet().size() + sg->getPeptideSet().getFirstAlphabeticalPeptide();
	QString index = PgUtils::getLexicalOrderedString(this->getPeptideSet().getTotalSpectra());
	index.append(PgUtils::getLexicalOrderedString(this->getPeptideSet().size()));
	index.append(PgUtils::getLexicalOrderedString(_proteinMatchSet.size()));
	index.append(this->getPeptideSet().getFirstAlphabeticalPeptide());
	//qDebug() << "QString SubGroup::getNonInformativeOrderString() " << index;
	return index;
}

bool SubGroup::addProteinMatch(const ProteinMatch * proteinMatch){
	if(proteinMatch->getPeptideSet().size()== _peptideSet.size()){
		if(_peptideSet.containsAll(proteinMatch->getPeptideSet())){
			_proteinMatchSet.insert(proteinMatch);
			return (true);
		}
		return (false);
	}
	if(_peptideSet.containsAll(proteinMatch->getPeptideSet())){
		return true;
	}
	if(proteinMatch->getPeptideSet().containsAll(_peptideSet)){
		qDebug() << "SubGroup::addProteinMatch() clear " << this;
		_proteinMatchSet.clear();
		_proteinMatchSet.insert(proteinMatch);
		_peptideSet.addAll(proteinMatch->getPeptideSet());
		return true;
	}
	return false;
}

QString SubGroup::getFirstAccession() const{
	if(_proteinMatchOrder.size()>0)
		return(_proteinMatchOrder.at(0)->getAccession());
	std::set<const ProteinMatch *>::const_iterator it;
	const ProteinMatch * prot;
	QString accession, test;
	for(it = _proteinMatchSet.begin(); it != _proteinMatchSet.end(); it++){
		prot = *it;
		test = prot->getAccession();
		if(accession.isEmpty())
			accession = test;
		else if(test<accession){
			accession = test;
		}
	}
	return(accession);
}


void SubGroup::indexAndOrderProteinMatch(){
	//qDebug() << "SubGroup::indexAndOrderProteinMatch() begin " << this << " "<< _proteinMatchSet.size();
	_proteinMatchOrder.clear();
	std::map<QString,const ProteinMatch *> index;
	std::set<const ProteinMatch *>::const_iterator it;
	const ProteinMatch * prot;
	QString accession;
	for(it = _proteinMatchSet.begin(); it != _proteinMatchSet.end(); it++){
		prot = *it;
		accession = prot->getAccession();
		index[accession]= prot;
	}

	std::map<QString, const ProteinMatch *>::iterator indexIt;
	_proteinMatchOrder.reserve(_proteinMatchSet.size());
	for(indexIt = index.begin(); indexIt != index.end(); indexIt++){
		//qDebug() << "SubGroup::indexAndOrderProteinMatch() accession " << indexIt->first;
		prot = indexIt->second;
		_proteinMatchOrder.push_back(prot);
	}
}

const std::vector<const ProteinMatch *> & SubGroup::getOrderedProteinMatchs() const {
 if (_proteinMatchOrder.empty()) {
		qDebug() << "SubGroup::getOrderedProteinMatchs()  _proteinMatchSet size" <<_proteinMatchSet.size() << " "<< this;
	 throw new GpError("ordered protein match list is empty. use SubGroup::indexAndOrderProteinMatch() first.");
 }
 return _proteinMatchOrder;
}
