/*
* Protein Grouper
* Copyright (C) 2014 Olivier Langella, Benoit Valot, Michel Zivy.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef GROUPNG_H
#define GROUPNG_H

#include "group.h"

class GroupNg:public Group
{

public:
    GroupNg(std::set<SubGroup*> & alreadyLinkedSg);
    GroupNg();
    virtual ~GroupNg();
    void push_back_subgroup(SubGroup * subGroup);

    void removeNonInformativeGroup(std::set<GroupNg *> * p_groupSet);


    bool contains(const SubGroup* p_sg) const;
    bool contains(const Peptide* p_sg) const;

private:
    GroupNg * removeNonInformativeSubGroup(std::set<GroupNg *> * p_groupSet);
   // bool fillFromPeptide(std::map<const Peptide*, std::set<SubGroup*>>  & mapPeptide2subGroup, const Peptide* p_peptide);
    bool isBondingPeptide(std::set<SubGroup*> & alreadyLinkedSg, const SubGroup* p_sg);
    bool pep1pep2sharingSubgroup(std::set<SubGroup*> & alreadyLinkedSg, const Peptide* p_pep1, const Peptide* p_pep2);
    bool makeItGrow(std::set<SubGroup*> & alreadyLinkedSg);

    void removeSubGroup(SubGroup * subGroup);
    void deindexPeptide2SubGroup(SubGroup * p_sg);
    bool indexPeptide2SubGroup(SubGroup * p_sg);
    std::map<const Peptide*, std::set<SubGroup*>>  _mapPeptide2subGroup;
};

#endif // GROUPNG_H
