/*
 * group_set.h
 *
 *  Created on: 22 mars 2013
 *      Author: valot
 */

#ifndef GROUP_SET_H_
#define GROUP_SET_H_

class Group;

#include <list>
#include "sub_group_set.h"
#include "sub_group.h"

class GroupSet {
public:
    GroupSet();
    virtual ~GroupSet();
    void deepClear();
    void push_back(Group * p_group);
    void push_back_all(GroupSet & groupSetToAdd);
    void groupingSubGroupSet(SubGroupSet& subGroupSet );
    void addSubGroup(SubGroup * subGroup);
    void removeNonInformativeGroup();
    void indexAndOrderGroup();
    unsigned int size()const {
        return _groupSet.size();
    }

    const std::vector<const Group *> & getOrderedGroups() const;

protected:
    bool add(Group * groupToAdd);
    void clear() {
        _groupOrder.clear();
        return _groupSet.clear();
    }

    std::list<Group *> _groupSet;
    std::vector<const Group *> _groupOrder;
};

#endif /* GROUP_SET_H_ */
