/*
 * group_set.cpp
 *
 *  Created on: 22 mars 2013
 *      Author: valot
 */

#include "group_set.h"
#include "group.h"
#include <iostream>
#include <QDebug>

#include "../gp_error.h"

GroupSet::GroupSet() {

}

GroupSet::~GroupSet() {
    _groupOrder.clear();
    _groupSet.clear();
}

void GroupSet::deepClear() {
    std::list<Group *>::iterator it;
    Group * gr;
    for (it = _groupSet.begin(); it != _groupSet.end(); it++) {
        gr = *it;
        delete (gr);
    }
}

void GroupSet::groupingSubGroupSet(SubGroupSet& subGroupSet) {
    std::list<SubGroup *>::const_iterator it;
    SubGroup * sg;
    for (it = subGroupSet.getSubgroups().begin(); it != subGroupSet.getSubgroups().end(); it++) {
        sg = *it;
        this->addSubGroup(sg);
    }

    qDebug() << "Search non informative subgroup" ;
    this->removeNonInformativeGroup();

    //Numbering
    qDebug() << "Index and Order group result" ;
    this->indexAndOrderGroup();
}
void GroupSet::addSubGroup(SubGroup * subGroup) {
    Group * group = new Group(subGroup);
    this->add(group);
}

void GroupSet::push_back(Group * p_group) {
  _groupSet.push_back(p_group);
}

void GroupSet::push_back_all(GroupSet & groupSetToAdd) {
    std::list<Group *>::const_iterator it;
    for (it = groupSetToAdd._groupSet.begin(); it != groupSetToAdd._groupSet.end(); it++) {
        _groupSet.push_back(*it);
    }

}

bool GroupSet::add(Group * groupToAdd) {
    qDebug() << "GroupSet::add _groupSet.size() " << _groupSet.size();
    std::set<Group *> removeGroup;
    bool fusion = false;
    std::list<Group *>::iterator it;
    Group * group;
    for (it = _groupSet.begin(); it != _groupSet.end(); it++) {
        group = *it;
        if (groupToAdd->fusionWith(group)) {
            fusion = true;
            removeGroup.insert(group);
        }
    }
    if (groupToAdd->isEmpty()) {
        throw new GpError("Error in GroupSet::add() : groupToAdd is empty");
    }

    _groupSet.push_back(groupToAdd);
    if (fusion) {
        std::set<Group *>::iterator itRemove;
        for (itRemove = removeGroup.begin(); itRemove != removeGroup.end(); itRemove++) {
            group = *itRemove;
            _groupSet.remove(group);
            delete (group);
        }
    }
    qDebug() << "GroupSet::add _groupSet.size() end " << _groupSet.size();
    return true;
}

void GroupSet::removeNonInformativeGroup() {
    //qDebug() << "GroupSet::removeNonInformativeGroup begin";
    std::set<Group *> toRegroup;
    std::list<Group *>::iterator it;
    std::set<Group *>::iterator regroupIt;
    for (it = _groupSet.begin(); it != _groupSet.end(); it++) {
        if ((*it)->removeNonInformative()) {
            //qDebug() << "Non Informative subgroup(s) were removed from current group";
            toRegroup.insert(*it);
        }
        else {
            //  qDebug() << "all subgroups are informative in current group";
        }
    }
    //Create New group from refactored group and remove old one
    GroupSet * p_newGroups;

    for (regroupIt = toRegroup.begin(); regroupIt != toRegroup.end();
            regroupIt++) {

        // (*regroupIt)->reGroup(*this);
        p_newGroups = new GroupSet();
        for (std::list<SubGroup *>::const_iterator itSg = (*regroupIt)->getSubGroupSet().getSubgroups().begin(); itSg != (*regroupIt)->getSubGroupSet().getSubgroups().end(); itSg++) {
            p_newGroups->addSubGroup(*itSg);
        }
        //  qDebug() << "before ";
        for (it = p_newGroups->_groupSet.begin(); it != p_newGroups->_groupSet.end(); it++) {
            //   qDebug() << "adding group "<< (*it)->getSubGroupSet().getFirstAccession();
            _groupSet.push_back(*it);
            // qDebug() << "push_back OK";
        }
        p_newGroups->clear();
        delete(p_newGroups);

        //qDebug() << "removing group "<< (*regroupIt);
        _groupSet.remove(*regroupIt);
        //   qDebug() << "delete group "<< (*regroupIt);
        delete(*regroupIt);
    }
}

const std::vector<const Group *> & GroupSet::getOrderedGroups() const {
    if (_groupOrder.empty()) {
        throw new GpError("ordered group list is empty. use GroupSet::indexAndOrderGroup() first.");
    }
    return _groupOrder;
}

void GroupSet::indexAndOrderGroup() {
    qDebug() << "GroupSet::indexAndOrderGroup begin " << _groupSet.size();
    _groupOrder.clear();
    std::map<const QString, std::map<const QString, Group *> > indexMap;
    for (std::list<Group *>::iterator it = _groupSet.begin(); it != _groupSet.end(); it++) {
        indexMap[(*it)->getOrderString()].insert(std::pair<QString, Group *>((*it)->getSubGroupSet().getFirstAccession(), (*it)));
    }

    qDebug() << "Indexing";
    _groupOrder.reserve(_groupSet.size());
    for (std::map<const QString, std::map<const QString, Group *> >::reverse_iterator itm = indexMap.rbegin(); itm != indexMap.rend(); itm++) {
        //qDebug() << "GroupSet::indexAndOrderGroup getFirstAccession "<< accessIt->first;
        for (std::map<const QString, Group *>::iterator it = itm->second.begin(); it != itm->second.end(); it++) {
            _groupOrder.push_back(it->second);
            it->second->indexAndOrder();
        }
    }
}
