/*
 *
 * Protein Grouper
 * Copyright (C) 2014 Olivier Langella, Benoit Valot, Michel Zivy.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *

 * group.h
 *
 *  Created on: 22 mars 2013 by Author: valot
 *
 */

#ifndef GROUP_H_
#define GROUP_H_

#include "../identification/peptide_set.h"
#include "sub_group.h"
#include "sub_group_set.h"
#include "group_set.h"

class Group {
public:
	Group(SubGroup * subGroup);
	virtual ~Group();
	void eatGroup(const Group * groupIncoming);
	bool fusionWith(Group * groupIncoming);
	bool removeNonInformative();

	void indexAndOrder() {
		_subGroupSet.indexAndOrderSubGroup();
	}

	const PeptideSet& getPeptideSet() const ;
	const SubGroupSet& getSubGroupSet() const;
	
	bool isEmpty() const;
	const QString getOrderString() const;
protected:
	Group();
	bool hasSpecificPeptideInSubGroup(SubGroup * subGroup) const;

	SubGroupSet _subGroupSet;
	PeptideSet _peptideSet;
};

#endif /* GROUP_H_ */
