/*
 * gp_params.cpp
 *
 *  Created on: 7 mars 2013
 *      Author: valot
 */

#include "gp_params.h"
#include <iostream>
#include <cstdio>
#include <QFile>
#include <QDebug>

using namespace std;

GpParams::GpParams(QStringList &args) :
		_p_infile(NULL), _p_fasta(NULL) {
	_p_outfile = new QFile();
	_p_outfile->open(stdout, QIODevice::WriteOnly);
	_p_in = new QTextStream(stdin, QIODevice::ReadOnly);
	_pepByProt = 2;
	_pepRepro = 1;
	this->parseArguments(args);
}

GpParams::~GpParams() {
	qDebug() << "Delete GpParams";
	if (_p_outfile != NULL) {
		_p_outfile->close();
		delete _p_outfile;
	}
	if (_p_infile != NULL) {
		_p_infile->close();
		delete _p_infile;
	}
	if (_p_fasta != NULL) {
		delete (_p_fasta);
	}
}

void GpParams::parseArguments(QStringList &args) {
	QStringList::const_iterator argIterator = args.constBegin();
	QString arg, value;
	for (; argIterator != args.end(); argIterator++) {
		arg = (*argIterator);
		if (arg == "--pepbyprot") {
			argIterator++;
			if (argIterator != args.end()) {
				value = (*argIterator);
				this->setPepByProt(value);
			} else {
				throw new GpError(QString("--pepbyprot need argument"));
			}
		} else if (arg == "--peprepro") {
			argIterator++;
			if (argIterator != args.end()) {
				value = (*argIterator);
				this->setPepRepro(value);
			} else {
				throw new GpError(QString("--peprepro need argument"));
			}
		} else if (arg == "-i" || arg == "--infile") {
			argIterator++;
			if (argIterator != args.end()) {
				value = (*argIterator);
				this->setInputStream(value);
			} else {
				throw new GpError(QString("-i|--infile need argument"));
			}

		} else if (arg == "-o" || arg == "--outfile") {
			argIterator++;
			if (argIterator != args.end()) {
				value = (*argIterator);
				this->setOuputStream(value);
			} else {
				throw new GpError(QString("-o|--outfile need argument"));
			}
		}else if (arg == "--fasta") {
			argIterator++;
			if (argIterator != args.end()) {
				value = (*argIterator);
				this->setFastaFile(value);
			} else {
				throw new GpError(QString("--fasta need argument"));
			}
		}
	}
}

void GpParams::setInputStream(QString value) {
	_p_infile = new QFile(value);
	if (!_p_infile->exists()
			|| !_p_infile->open(QIODevice::ReadOnly | QIODevice::Text))
		throw new GpError(QString("-i|--infile need valid file argument"));
	delete (_p_in);
	_p_in = new QTextStream(_p_infile);
	cerr << "New input : " << value.toStdString() << endl;
}

void GpParams::setOuputStream(QString value) {
	QFile * p_outfile = new QFile(value);
	if (!p_outfile->open(QIODevice::WriteOnly | QIODevice::Text))
		throw new GpError(QString("-o|--outfile need valid file argument"));
	_p_outfile->close();
	delete (_p_outfile);
	_p_outfile = p_outfile;
	cerr << "New output : " << value.toStdString() << endl;
}

void GpParams::setFastaFile(QString value){
	QFile * p_fasta = new QFile(value);
	if (!p_fasta->exists()) {
		throw new GpError(QString("--fasta file doesn't exist"));
	}else if (!p_fasta->open(QIODevice::ReadOnly | QIODevice::Text)) {
		throw new GpError(QString("--fasta file is not readable"));
	}
	if(_p_fasta!=NULL){
	  _p_fasta->close();
	  delete(_p_fasta);
	}
	_p_fasta = p_fasta;
	cerr <<  "Set Fasta file filtering : " << value.toStdString() << endl;
}

void GpParams::setPepByProt(QString value) {
	bool test = true;
	_pepByProt = value.toInt(&test);
	if (!test)
		throw new GpError(QString("--pepbyprot need int argument"));
	cerr << "New pepbyprot : " << _pepByProt << endl;
}

void GpParams::setPepRepro(QString value) {
	bool test = true;
	_pepRepro = value.toInt(&test);
	if (!test)
		throw new GpError(QString("--peprepro need int argument"));
	cerr << "New peprepro : " << _pepRepro << endl;
}
