/*
 * fasta_filter.cpp
 *
 *  Created on: 27 mars 2013
 *      Author: valot
 */

#include "fasta_filter.h"
#include <QDebug>

FastaFilter::FastaFilter(GpParams * params) :
		DataFilter(params) {

}

FastaFilter::~FastaFilter() {
	// TODO Auto-generated destructor stub
}

void FastaFilter::filterResult(std::map<QString, Peptide*>& peptideList,
		std::map<QString, ProteinMatch*>& proteinMatchList) {
	if (!_p_params->isFastaFile())
		return;
	QFile* fasta = _p_params->getFastaFile();
	
	std::set<QString> accessions;
	//Search accession conta
	QTextStream in(fasta);
	while (!in.atEnd()) {
		QString line = in.readLine();
		if (line.startsWith(">")) {
			QStringList elements = line.split(" ");
			if (elements.size() > 0) {
				QString access = elements.at(0);
				accessions.insert(access.remove(0,1));
			}
		}
	}
	fasta->close();

	//Remove contaminants
	std::map<QString, ProteinMatch*>::iterator proteinIt, proteinToRemove;
	ProteinMatch * p_protein;
	for (proteinIt = proteinMatchList.begin();
			proteinIt != proteinMatchList.end();) {
		p_protein = proteinIt->second;
		if (accessions.count(p_protein->getAccession()) == 1) {
			qDebug() << "Remove Contaminant : " << p_protein->getAccession();
			proteinToRemove = proteinIt;
			proteinIt++;
			proteinMatchList.erase(proteinToRemove);
			delete (p_protein);
		} else {
			proteinIt++;
		}
	}
	std::cerr << "Remove protein contaminants from fasta file : " << proteinMatchList.size() << std::endl;
}
