/*
*
* Protein Grouper
* Copyright (C) 2014 Olivier Langella, Benoit Valot, Michel Zivy.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include <QString>
#include <QLocale>
#include <QCoreApplication>
#include <QDateTime>
#include <QDir>
#include <QThreadPool>
#include <iostream>
#include "gp_lib_config.h"
#include "pg_protseqfilterpeptideorphans.h"

#include "gp_error.h"
using namespace std;

void display_help(ostream & out) {
    out << "Usage: pg-filterproteinpeptideorphans [OPTION]" << endl;
    out << endl;
    out << "filter proteins that has no peptide in common with others." << endl;
    //  out << "\n" << endl;
    out << endl;
//	out << "For additional information, see the groupingprotein Homepage :" << endl;
//	out << "http://pappso.inra.fr/bioinfo/gpf/" << endl;
}

int main(int argc, char **argv) {

    //QTextStream consoleErr(stderr);
    //QTextStream consoleOut(stdout);

    QCoreApplication app(argc, argv);
    QLocale::setDefault(QLocale::system());
    const QDateTime dt_begin = QDateTime::currentDateTime();

    //Display help or version and quit
    QStringList arguments = app.arguments();
    for (QStringList::const_iterator argIterator = arguments.constBegin(); argIterator != arguments.end(); argIterator++) {
        QString arg = (*argIterator);
        if ((arg == "--help") || (arg == "-h")) {
            display_help(cerr);
            return 0;
        } else if ((arg == "--version") || (arg == "-v")) {
            cerr << "This is proteingrouper program version " << GP_VERSION << endl;
            return 0;
        } else if ((arg == "--cpus") || (arg == "-c")) {
            argIterator++;
            if (argIterator != arguments.end()) {
                unsigned int nbcpus = (*argIterator).toUInt();
                QThreadPool::globalInstance()->setMaxThreadCount(nbcpus);
            }
        }
    }


    PgProtSeqFilterPeptideOrphans* engine;
    try {
        engine = new PgProtSeqFilterPeptideOrphans();
        engine->readInputStream();
        delete(engine);
    } catch (GpError* error) {
        cerr << "Oups, proteingrouper has failed :" << endl;
        cerr << error->qwhat().toStdString() << endl;
        return 1;
    } catch (exception& error) {
        cerr << "Oups, proteingrouper has failed :" << endl;
        cerr << error.what() << endl;
        return 1;
    }
    return 0;
}

