#include <QString>
#include <QLocale>
#include <QCoreApplication>
#include <QDateTime>
#include <QDir>
#include <iostream>
#include "gp_lib_config.h"
#include "gp_engine.h"
#include "gp_params.h"
#include "gp_error.h"
#include "gp_engine.h"

using namespace std;

void display_help(ostream & out) {
	out << "Usage: gp-grouping [OPTION]" << endl;
	out << endl;
	out << "Perform grouping of proteins from peptide results." << endl;
	out << "Use gp-read-.. script first to process search engine result." << endl;
	out << endl;
	out << "optional arguments:" << endl;
	out << "  --peprepro [int] \t\t Define the minimum reproductibility of the peptide to be conserved. default:1" << endl;
	
	//number of unique peptide sequence identified in all samples
	out << "  --pepbyprot [int] \t\t Define the minimum number of peptide to conserve a protein. default:2" << endl;
	out << "  --fasta [FILE] \t\t Remove proteins from this fasta file default:no" << endl;
	out << "  -i, --infile [FILE] \t\t Open peptide result default:STDIN" << endl;
	out << "  -o, --outfile [FILE] \t\t Save grouping result default:STDOUT" << endl;
	out << "  -h, --help \t\t\t show this help and exit" << endl;
	out << "  -v, --version \t\t show version number and exit" << endl;
	//  out << "\n" << endl;
	out << endl;
//	out << "For additional information, see the groupingprotein Homepage :" << endl;
//	out << "http://pappso.inra.fr/bioinfo/gpf/" << endl;
}

int main(int argc, char **argv) {

	//QTextStream consoleErr(stderr);
	//QTextStream consoleOut(stdout);

	QCoreApplication app(argc, argv);
	QLocale::setDefault(QLocale::system());
	const QDateTime dt_begin = QDateTime::currentDateTime();

	//Display help or version and quit
	QStringList arguments = app.arguments();
	QStringList::const_iterator argIterator = arguments.constBegin();
	for (; argIterator != arguments.end(); argIterator++) {
		QString arg = (*argIterator);
		if ((arg == "--help") || (arg == "-h")) {
			display_help(cerr);
			return 0;
		} else if ((arg == "--version") || (arg == "-v")) {
			cerr << "This is groupingprotein program version " << GP_VERSION << endl;
			return 0;
		}
	}

	//Parsing arguments
	GpParams* params;
	try {
		params = new GpParams(arguments);
	} catch (GpError* error) {
		cerr << "groupingprotein : invalid use." << endl;
		cerr << error->qwhat().toStdString() << endl;
		cerr << "Try 'groupingprotein --help' for more information." << endl;
		return 1;
	}
	cerr << "Finish reading parameter" << endl;
	GpEngine* engine;
	try {
		engine = new GpEngine(params);
		engine->performedTraitment();
		delete(params);
		delete(engine);
	} catch (GpError* error) {
		cerr << "Oups, groupingprotein has failed :" << endl;
		cerr << error->qwhat().toStdString() << endl;
		return 1;
	} catch (exception& error){
		cerr << "Oups, groupingprotein has failed :" << endl;
		cerr << error.what() << endl;
		return 1;
	}
	return 0;
}

