
import sys
files = [f.strip() for f in open(sys.argv[1],"r").readlines()]

outlines = []
for f in files:

    file_source = [l.strip() for l in open(f,"r").readlines()]

    data = []
    gene_1 = ""  
    gene_2 = ""
    check_name = 0 # Check file for names 
    check_data = 0 # Check file for data
    for index in range(len(file_source)):

        if file_source[index].startswith("Use runmode"):
            gene_1 = file_source[index+2].strip().split(" ")[0]
            gene_2 = file_source[index+3].strip().split(" ")[0]
            if not gene_1 == "" and not gene_2 == "":
                check_name = 1


        if file_source[index].startswith("seq. seq."):
            data.extend([v for v in file_source[index+2].split(" ") if v])            
            if not data == []:
                 check_data = 1
    
    if check_name == 0:
        print "No gene name data: File  " + f + " is empty or incomplete." 
    elif check_data == 0:
        print "No dN/dS data: File  " + f + " is empty or incomplete."
    else:
    
        S = data[2]
        N = data[3]
        dN = data[7]
        seN = data[9]
        dS = data[10]
        seS = data[12]
        if float(dS) > 0:
            dNdS = str(float(dN)/float(dS))   
        else:
            dNdS = "NA"
        if float(dS)+float(seS) > 0:
            dNdS_min = str((float(dN)-float(seN))/(float(dS)+float(seS))) #min KaKs given SE
        else:
            dNdS_min = "NA"
        if float(dS)-float(seS) > 0:
            dNdS_max = str((float(dN)+float(seN))/(float(dS)-float(seS))) #max KaKs given SE
        else:
            dNdS_max = "NA"

        outlines.append(gene_1 + "\t" + gene_2 + "\t" + S + "\t" + N + "\t" + dN + "\t" + seN + "\t" + dS + "\t" + seS + "\t" + dNdS  + "\t" + dNdS_min + "\t"  + dNdS_max + "\n")

header = "Gene1\tGene2\tS\tN\tdN\tseN\tdS\tseS\tdNdS\dNdS_min\tdNdS_max\n"

output = open("Combined_yn00_Results.txt","w")
output.write(header)
output.write("".join(outlines))
output.close()

