import sys, os
from os.path import isfile
pep_folder = sys.argv[1]
nuc_folder = sys.argv[2]

if not pep_folder.endswith("/"):
    pep_folder += "/"

if not nuc_folder.endswith("/"):
    nuc_folder += "/"

pep_files = [f for f in os.listdir(pep_folder) if isfile(pep_folder+f) and not f.endswith(".mafft_align")]
nuc_files = [f for f in os.listdir(nuc_folder) if isfile(nuc_folder+f)]

pep_dict = {}
for f in pep_files:
    pep_dict[f.strip().split(".")[-1]] = f

nuc_dict = {}
for f in nuc_files:
    nuc_dict[f.strip().split(".")[-1]] = f

outlines = []
for key in pep_dict.keys():
    
    if key in nuc_dict.keys():
        pep_file = pep_folder + pep_dict[key] + ".mafft_align" 
        nuc_file = nuc_folder + nuc_dict[key]
        outlines.append("python AlnUtility.py -f bt_align -pep " + pep_file + " -cds " + nuc_file  + "\n")
    else:
        print "Nucleotide Compliment is not present for " + pep_dict[key]

output = open("BackAlign.cc","w")
output.write("".join(outlines))
output.close()
