
import sys

parameters = {}

parameters["outfile_tail"] = ".codeml_Results"
parameters["commandfile_tail"] = ".codeml.ctl"

parameters["noisy"] = "3"
parameters["verbose"] = "1"
parameters["runmode"] = "-2"

parameters["seqtype"] = "1"
parameters["CodonFreq"] = "2"
parameters["clock"] = "0"
parameters["model"] = "0"
parameters["NSsites"] = "0"
parameters["icode"] = "0"
parameters["ncatG"] = "10"

parameters["fix_kappa"] = "0"
parameters["kappa"] = "2.6"
parameters["fix_omega"] = "0"
parameters["omega"] = "1"
parameters["Small_Diff"] = "3e-7"

parameters["cleandata"] = "0"
parameters["getSE"] = "0"
parameters["RateAncestor"] = "0"

if len(sys.argv) > 2: 
    parameter_file = open(sys.argv[2],"r").readlines()
    for ln in parameter:
        split_ln = ln.strip().split("\t")
        if split_ln[0] in parameters.keys():
            parameters[split_ln[0]] = split_ln[1]   
        else:
            print "WARNING: parameter " + split_ln[0] + " not recognized. Check your parameter file"

files = [f.strip() for f in open(sys.argv[1],"r").readlines()]

command_files = []
for f in files:
    
    file_root = ".".join(f.strip().split(".")[0:-1])
    outfile = file_root + parameters["outfile_tail"]

    command_file = file_root + parameters["commandfile_tail"]
    
    command_files.append(command_file)

    outlines = []

    outlines.append("seqfile = " + f + "\n")
    outlines.append("outfile = " + outfile + "\n")

    outlines.append("\n")

    outlines.append("noisy = " + parameters["noisy"] + " * 0,1,2,3: how much rubbish on the screen\n")
    outlines.append("verbose = " + parameters["verbose"]  + " * 1: detailed output, 0: concise output\n")
    outlines.append("runmode = " + parameters["runmode"] + " * 0: user tree; 1: semi-automatic; 2: automatic; 3: StepwiseAddition; (4,5):PerturbationNNI\n")

    outlines.append("\n")

    outlines.append("seqtype = " + parameters["seqtype"] + " * 1:codons; 2:AAs; 3:codons-->AAs\n")
    outlines.append("CodonFreq = " + parameters["CodonFreq"] + " * 0:1/61 each, 1:F1X4, 2:F3X4, 3:codon table\n")
    outlines.append("clock = " + parameters["clock"] + " * 0: no clock, unrooted tree, 1: clock, rooted tree\n")
    outlines.append("model = " + parameters["model"] + " * models for codons: 0:one, 1:b, 2:2 or more dN/dS ratios for branches\n")
    outlines.append("NSsites = " + parameters["NSsites"] + "  * 0:one w;1:neutral;2:positive; 3:discrete;4:freqs;\n")
    outlines.append("\t * 5:gamma;6:2gamma;7:beta;8:beta&w;9:beta&gamma;\n")
    outlines.append("\t * 10:beta&1+gamma; 11:beta&1>normal; 12:0&2normal; 13:3normal\n")
    outlines.append("icode = " + parameters["icode"] + " * 0:standard genetic code; 1:mammalian mt; 2-10:see below[?]\n")
    outlines.append("ncatG = " + parameters["ncatG"] + " * # of categories in dG of NSsites models\n")

    outlines.append("\n")

    outlines.append("fix_kappa = " + parameters["fix_kappa"] + " * 1: kappa fixed, 0: kappa to be estimated\n")
    outlines.append("kappa = " + parameters["kappa"] + " * initial or fixed kappa\n")
    outlines.append("fix_omega = " + parameters["fix_omega"] + " * 1: omega or omega_1 fixed, 0: estimate\n")
    outlines.append("omega = "  + parameters["omega"] + " * initial or fixed omega, for codons or codon-based AAs\n")
    outlines.append("Small_Diff = " + parameters["Small_Diff"] + " * [I think this is used to determine convergence of ML algorithm]\n")

    outlines.append("\n")

    outlines.append("cleandata = " + parameters["cleandata"] + " * remove sites with ambiguity data (1:yes, 0:no)?\n")
    outlines.append("getSE = " + parameters["getSE"] + " * 0: don't want them, 1: want S.E.s of estimates\n")
    outlines.append("RateAncestor = " + parameters["RateAncestor"] + " * (0,1,2): rates (alpha>0) or ancestral states (1 or 2)\n")

    output = open(command_file,"w")
    output.write("".join(outlines))
    output.close()

command_files_outlines = []
for c_file in command_files:
    command_files_outlines.append("codeml " + c_file + "\n")

output = open("CodemlCommands_Pairwise.cc","w")
output.write("".join(command_files_outlines))
output.close()
    
