import sys

parameters = {}
parameters["outfile_tail"] = ".yn00_Results"
parameters["commandfile_tail"] = ".yn00.ctl"

parameters["verbose"] = "1"

parameters["icode"] = "0"
parameters["weighting"] = "0"
parameters["commonf3x4"] = "0"

if len(sys.argv) > 2:
    parameter_file = open(sys.argv[2],"r").readlines()
    for ln in parameter_file:
        split_ln = ln.strip().split("\t")
        if split_ln[0] in parameters.keys():
            parameters[split_ln[0]] = split_ln[1]
        else:
            print "WARNING: parameter " + split_ln[0] + " not recognized. Check your parameter file"

seq_files = [ln.strip() for ln in open(sys.argv[1],"r").readlines()]

command_files = []
for f in seq_files:
    
    file_root = ".".join(f.strip().split(".")[:-1])
    outfile = file_root + parameters["outfile_tail"]

    command_file = file_root + parameters["commandfile_tail"]

    command_files.append(command_file)

    outlines = []

    outlines.append("seqfile = " + f + "\n")
    outlines.append("outfile = " + outfile + "\n")
    
    outlines.append("verbose = " + parameters["verbose"]  + " * 1: detailed output, 0: concise output\n")
    
    outlines.append("icode = " + parameters["icode"] + " * 0:standard genetic code; 1:mammalian mt; 2-10:see below[?]\n")
    outlines.append("weighting = " + parameters["weighting"] + " * weighting pathways between codons (0/1)?\n")
    outlines.append("commonf3x4 = " + parameters["commonf3x4"] + " * use one set of codon freqs for all pairs (0/1)? \n")

    output = open(command_file,"w")
    output.write("".join(outlines))
    
command_files_outlines = []
for c_file in command_files:
    command_files_outlines.append("yn00 " + c_file + "\n")

output = open("yn00_Commands.cc","w")
output.write("".join(command_files_outlines))
output.close()
