import sys, time, math


def get_annotated(inp_coverage):
    seq_data={}
    for l1 in inp_coverage:
        if not l1.startswith("#"):
            data=l1.strip().split("\t")
            ba_id=data[0].split("_")[0]
            
            seq_data[ba_id]=data[1:]
   return seq_data

def get_score(seq_in, atgc_c):
    sco_t=0
    for i in range(0, len(seq_in)):
        sco=float(atgc_c[seq_in[i]][i])
        sco_t=sco_t+sco
    return sco_t

with open(sys.argv[1], "r") as inp_coverage:
    atg_atgc=get_annotated(inp_coverage)


output=open(sys.argv[2]+".TIS_score", "w")
output.write("#python %s\n" %(" ".join(sys.argv)))
output.write("#file_name\tA_base\tT_base\tC_base\tG_base\n")

for f_i in range(2, len(sys.argv)):
    with open(sys.argv[f_i], "r") as inp_coverage:
        fi_nmae=sys.argv[f_i].strip().split("/")[-1]
        output.write("%s\t"%(fi_nmae))
        n=0
        for line in inp_coverage:
            if not line.startswith("#") and not line.startswith(">"):
                n+=1
                seq=line.strip()
                if "N" not in seq:
                    score=get_score(seq, atg_atgc)
                    output.write("%s\t"%(score))
                else:
                    print line.strip()
        output.write("\n")
output.close()
