
import sys

output=open(sys.argv[1]+"_abundance.txt", 'w')
output.write("#python %s\n" %(" ".join(sys.argv)))
output.write("#tRNA_ID\tamino_acid\tanticodon\tanticodon_copy_number\ttRNA_seq_abundance\tanticodon_seq_abundance\n")

def get_abun_tRNA_gene(in1):
    copy={}
    for i1 in in1:
        if not i1.startswith("#"):
            data=i1.strip().split("\t")
            anticodon=data[0]
                
            if anticodon not in copy.keys():
                copy[anticodon]=int(float(data[2]))
            else:
                copy[anticodon]=copy[anticodon]+int(float(data[2]))
    return copy

def get_abun_anticodon(in2, abun_tR):
    anti={}
    for i2 in in2:
        if not i2.startswith("#"):
            data=i2.strip().split("\t")
            anticodon=data[2]
            
            if anticodon not in anti.keys():
                anti[anticodon]=int(abun_tR[data[0]])
            else:
                anti[anticodon]=anti[anticodon]+int(abun_tR[data[0]])
    return anti

with open(sys.argv[1], 'r') as in1:
    abun_tR=get_abun_tRNA_gene(in1)

with open(sys.argv[2], 'r') as in2:
    anti=get_abun_anticodon(in2, abun_tR)

with open(sys.argv[2], 'r') as in3:
    n=0
    for l1 in in3:
        l1=l1.strip()
        if not l1.startswith("#"):
            data=l1.strip().split("\t")
            
            id=data[0]
            output.write("%s\t%s\t%s\n"%(l1.strip(), abun_tR[id], anti[data[2]]))
            n+=1

output.close()
