import sys, time

def get_seq_info(inp_coverage, out):
    for l1 in inp_coverage:
        if not l1.startswith("#"):
            data=l1.strip().split("\t")
            feature="NA"
            if data[4]=="5UTR":
                if data[9] =="NO":
                    feature="separateORF"
                elif data[9] =="Yes" and data[8]=="NO":
                    feature="olORF"
                elif data[9] =="Yes" and data[8]=="Yes":
                    feature="Nter"
                else:
                    feature="NA"
                        
            elif data[4]=="dTIS":
                if data[8] =="Yes" and data[9] =="With_CDS":
                    feature="Nter"
                elif data[8] =="NO" and data[9] =="With_CDS":
                    feature="separateORF"
                else:
                    feature="NA"

            out.write("%s\t%s\n"%(l1.strip(), feature))

output=open(sys.argv[1]+".features", "w")
output.write("#python %s\n" %(" ".join(sys.argv)))

with open(sys.argv[1], "r") as inp_coverage:
    get_seq_info(inp_coverage, output)

output.close()
