args <- commandArgs(trailingOnly = TRUE)
INPUTFILE = args[1]
ColumnPlotted = as.integer(args[2])

NameArg <- function(s,e){  # producing vector like: c(s, '', '', s+3, '', '',e-3, ...,e, '', '')
  A <- c()
  for(i in c(s:e)){
    #print(i)
    if(i%%3==0){
      A=c(A, i)
    }else{
      A=c(A, '')
    }
  }
  return(A)
}


MetaTable <- read.table(file = INPUTFILE, header = TRUE)

pdf(paste(INPUTFILE, '.to_TIS_', colnames(MetaTable)[ColumnPlotted],'.pdf',sep=''))

options(scipen = 50)
par(mar=c(5,5,4,2))
DATASET_vec = MetaTable[MetaTable$Distance>=-20 & MetaTable$Distance <=41 , ColumnPlotted]
barplot(DATASET_vec, col=c('blue', 'green', 'red'), space = 1, xlab = 'Distance to initiation codon (nt)', 
  ylab = paste(colnames(MetaTable)[ColumnPlotted], '\n', sep=''), legend.text = c('frame_0','frame_1','frame_2'), 
  names.arg = NameArg(-20, 41), border = NA, las=2)

dev.off()

