#!/usr/bin/env perl

#
# ========================================================================
# Prepare the distribution length by creating a file with teh content
# {length TAB count NEWLINE}
# ========================================================================
#

use strict;

use File::Basename;
use Getopt::Long;

my $APPLDIR = "/data/projects/two-way";
my $DATADIR = "$APPLDIR/data";

my @ORIGINS = ("query", "target");
my @TYPES   = ("block", "gap");

# The minimum gap size
my $mingap = 10;

# ------------------------------------------------------------------------
# Usage
# ------------------------------------------------------------------------

if (!@ARGV) {
	my $name = basename $0;
	print <<EOS;
USAGE: $name -m mingap

WHERE
    mingap - the minimum gap size
EOS
	exit 0;
}

# ------------------------------------------------------------------------
# Get parameters and check them
# ------------------------------------------------------------------------

exit 1
  if (
	!GetOptions(
		'm=i' => \$mingap
	)
  );

#
# ------------------------------------------------------------------------
# main
# ------------------------------------------------------------------------
#
sub main {
	for my $origin (@ORIGINS) {
		for my $type (@TYPES) {
			my $file = "calc.$origin.$type.fasta";

			# Map length -> count
			my %lens;

			if (-f $file) {
				open(F, "<", $file);
				while (my $line = <F>) {
					if ($line =~ m/>.*len:(\d+)/) {
						$lens{$1}++;
					}
				}
				close(OUT);
			}

			open(OUT, ">", "calc.$origin.$type.lens");
			for my $len (sort {$a <=> $b} keys %lens) {
				if ($type eq "block" || $len >= $mingap) {
					print OUT "$len\t$lens{$len}\n";
				}
			}
			close(F);
		}
	}
}

main();
