#!/usr/bin/env bash

set -eo pipefail
set -o errexit

__base="$(basename "${BASH_SOURCE[0]}")"
__wd=$PWD

#
# ------------------------------------------------------------------------
# Document
# written by Fengjun Zhang
#
# Input files:
# $input_directory
#
# Output files:
# stdout
# ------------------------------------------------------------------------
#


#
# ------------------------------------------------------------------------
# Usage document
# ------------------------------------------------------------------------
#

function usage_doc () {
  e=$(printf "\e")
  fBold="$e[1m"
  fUnL="$e[4m"
  unF="$e[0m"
  cat <<EOF

$__base document
${fBold}NAME$unF
    $fBold$__base$unF

${fBold}USAGE$unF
    bash $fBold$__base$unF TWOWAY_FOLDER

${fBold}DESCRIPTION$unF
    $fBold$__base$unF is a bash script to check progress of 2-way

EOF
  exit
}


#
# ------------------------------------------------------------------------
# Main
# ------------------------------------------------------------------------
#
for TWOWAY_FOLDER in "$@" ; do

  [[ "$TWOWAY_FOLDER" =~ '/'$ ]] && tmp=${TWOWAY_FOLDER::-1} && TWOWAY_FOLDER=$tmp && unset tmp
  echo "you are looking at $TWOWAY_FOLDER project"

  [[ ! -d $TWOWAY_FOLDER ]] && echo "TWOWAY_FOLDER not found!" && usage_doc

  ## last
  if [[ -f $TWOWAY_FOLDER/calc.result.maf || -f $TWOWAY_FOLDER/calc.result.axt_LAST.tar.gz ]]; then
    echo "last mode recognized ..."
    if [[ -f $TWOWAY_FOLDER/calc.result.axt ]]; then
      echo "last: whole process finished"
    elif [[ -a $TWOWAY_FOLDER/calc.result.chain ]]; then
      num_target=$( fgrep -c ">" $TWOWAY_FOLDER/input.target)
      echo "last: target has $num_target seq ..."
      num_chain=$(fgrep -c "target" $TWOWAY_FOLDER/calc.2way.log) || num_chain=0
      pc_chain=$(($num_chain * 100 / $num_target))
      [[ $num_chain == 0 ]] && echo "last: chain file has no result yet"
      echo "last: chain file recognized, current progress: ${pc_chain}%"
    elif [[ -f $TWOWAY_FOLDER/calc.result_tmp.axt ]]; then
      echo "last: alignment completed"
    fi

  ## lastz
  elif [[ -f $TWOWAY_FOLDER/input.target.sizes ]]; then
    echo "lastz mode recognized ..."
    if [[ -a $TWOWAY_FOLDER/calc.result.chain ]]; then
      num_target=$( wc -l $TWOWAY_FOLDER/*target*sizes | awk '{print $1}')
      echo "lastz: target has $num_target seq ..."
      num_chain=$(fgrep -c "target" $TWOWAY_FOLDER/calc.2way.log) || num_chain=0
      pc_chain=$(($num_chain * 100 / $num_target))
      [[ $num_chain == 0 ]] && echo "lastz: chain file has no result yet"
      echo "lastz: chain file recognized, current progress: ${pc_chain}%"
    elif [[ -f $TWOWAY_FOLDER/calc.result.axt.tmp ]]; then
      num_target=$( wc -l $TWOWAY_FOLDER/*target*sizes | awk '{print $1}')
      echo "lastz: target has $num_target seq ..."
      num_lastz_complete=$(awk 'END{print NR}'  $TWOWAY_FOLDER/calc.lastz.progress) || num_lastz_complete=0
      pc_lastz=$(($num_lastz_complete * 100 / $num_target))
      echo "lastz: alignment recognized, current progress: ${pc_lastz}%"
    elif [[ -f $TWOWAY_FOLDER/calc.result.axt ]]; then
      echo "lastz: whole process finished"
    fi
  else
    echo "did not find useful information, probably hasn't started yet..."
  fi

  done
